/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.compile.tasks;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Map;
import java.util.Objects;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBufferSorter;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildContext;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildOutput;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderCache;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderContext;
import me.jellysquid.mods.sodium.client.render.chunk.compile.tasks.ChunkBuilderTask;
import me.jellysquid.mods.sodium.client.render.chunk.data.BuiltSectionInfo;
import me.jellysquid.mods.sodium.client.render.chunk.data.BuiltSectionMeshParts;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.DefaultTerrainRenderPasses;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import me.jellysquid.mods.sodium.client.util.task.CancellationToken;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_5539;
import net.minecraft.class_827;
import net.minecraft.class_852;
import org.embeddedt.embeddium.api.ChunkDataBuiltEvent;
import org.embeddedt.embeddium.chunk.MeshAppenderRenderer;

public class ChunkBuilderMeshingTask
extends ChunkBuilderTask<ChunkBuildOutput> {
    private final RenderSection render;
    private final ChunkRenderContext renderContext;
    private final int buildTime;
    private class_243 camera = class_243.field_1353;

    public ChunkBuilderMeshingTask(RenderSection render, ChunkRenderContext renderContext, int time) {
        this.render = render;
        this.renderContext = renderContext;
        this.buildTime = time;
    }

    public ChunkBuilderMeshingTask withCameraPosition(class_243 camera) {
        this.camera = camera;
        return this;
    }

    @Override
    public ChunkBuildOutput execute(ChunkBuildContext buildContext, CancellationToken cancellationToken) {
        BuiltSectionInfo.Builder renderData = new BuiltSectionInfo.Builder();
        class_852 occluder = new class_852();
        ChunkBuildBuffers buffers = buildContext.buffers;
        buffers.init(renderData, this.render.getSectionIndex());
        BlockRenderCache cache = buildContext.cache;
        cache.init(this.renderContext);
        WorldSlice slice = cache.getWorldSlice();
        int minX = this.render.getOriginX();
        int minY = this.render.getOriginY();
        int minZ = this.render.getOriginZ();
        int maxX = minX + 16;
        int maxY = minY + 16;
        int maxZ = minZ + 16;
        class_2338.class_2339 blockPos = new class_2338.class_2339(minX, minY, minZ);
        class_2338.class_2339 modelOffset = new class_2338.class_2339();
        BlockRenderContext context = new BlockRenderContext(slice);
        try {
            for (int y = minY; y < maxY; ++y) {
                if (cancellationToken.isCancelled()) {
                    return null;
                }
                for (int z = minZ; z < maxZ; ++z) {
                    for (int x = minX; x < maxX; ++x) {
                        class_827 renderer;
                        class_2586 entity;
                        class_3610 fluidState;
                        class_2680 blockState = slice.getBlockState(x, y, z);
                        if (blockState.method_26215() && !blockState.method_31709()) continue;
                        blockPos.method_10103(x, y, z);
                        modelOffset.method_10103(x & 0xF, y & 0xF, z & 0xF);
                        if (blockState.method_26217() == class_2464.field_11458) {
                            class_1087 model = cache.getBlockModels().method_3335(blockState);
                            long seed = blockState.method_26190((class_2338)blockPos);
                            context.update((class_2338)blockPos, (class_2338)modelOffset, blockState, model, seed);
                            cache.getBlockRenderer().renderModel(context, buffers);
                        }
                        if (!(fluidState = blockState.method_26227()).method_15769()) {
                            cache.getFluidRenderer().render(slice, fluidState, (class_2338)blockPos, (class_2338)modelOffset, buffers);
                        }
                        if (blockState.method_31709() && (entity = slice.method_8321((class_2338)blockPos)) != null && (renderer = class_310.method_1551().method_31975().method_3550(entity)) != null) {
                            renderData.addBlockEntity(entity, !renderer.method_3563(entity));
                        }
                        if (!blockState.method_26216((class_1922)slice, (class_2338)blockPos)) continue;
                        occluder.method_3682((class_2338)blockPos);
                    }
                }
            }
            MeshAppenderRenderer.renderMeshAppenders(this.renderContext.getMeshAppenders(), context.localSlice(), this.renderContext.getOrigin(), buffers);
        }
        catch (class_148 ex) {
            throw this.fillCrashInfo(ex.method_631(), slice, (class_2338)blockPos);
        }
        catch (Throwable ex) {
            throw this.fillCrashInfo(class_128.method_560((Throwable)ex, (String)"Encountered exception while building chunk meshes"), slice, (class_2338)blockPos);
        }
        Reference2ReferenceOpenHashMap meshes = new Reference2ReferenceOpenHashMap();
        for (TerrainRenderPass pass : DefaultTerrainRenderPasses.ALL) {
            BuiltSectionMeshParts mesh = buffers.createMesh(pass);
            if (mesh == null) continue;
            if (pass.isSorted()) {
                Objects.requireNonNull(mesh.getIndexData());
                ChunkBufferSorter.sort(mesh.getIndexData(), mesh.getSortState(), (float)this.camera.field_1352 - (float)minX, (float)this.camera.field_1351 - (float)minY, (float)this.camera.field_1350 - (float)minZ);
            }
            meshes.put(pass, mesh);
            renderData.addRenderPass(pass);
        }
        renderData.setOcclusionData(occluder.method_3679());
        ChunkDataBuiltEvent.BUS.post(new ChunkDataBuiltEvent(renderData));
        return new ChunkBuildOutput(this.render, renderData.build(), (Map<TerrainRenderPass, BuiltSectionMeshParts>)meshes, this.buildTime);
    }

    private class_148 fillCrashInfo(class_128 report, WorldSlice slice, class_2338 pos) {
        class_129 crashReportSection = report.method_556("Block being rendered", 1);
        class_2680 state = null;
        try {
            state = slice.method_8320(pos);
        }
        catch (Exception exception) {
            // empty catch block
        }
        class_129.method_586((class_129)crashReportSection, (class_5539)slice, (class_2338)pos, (class_2680)state);
        crashReportSection.method_578("Chunk section", (Object)this.render);
        if (this.renderContext != null) {
            crashReportSection.method_578("Render context volume", (Object)this.renderContext.getVolume());
        }
        return new class_148(report);
    }
}

