/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.gui;

import com.google.common.collect.Multimap;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.data.fingerprint.HashedFingerprint;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.gui.SodiumOptionsGUI;
import me.jellysquid.mods.sodium.client.gui.console.Console;
import me.jellysquid.mods.sodium.client.gui.console.message.MessageLevel;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionFlag;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.storage.OptionStorage;
import me.jellysquid.mods.sodium.client.gui.widgets.FlatButtonWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.minecraft.class_1044;
import net.minecraft.class_1049;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_446;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.embeddedt.embeddium.client.gui.options.OptionIdentifier;
import org.embeddedt.embeddium.gui.frame.AbstractFrame;
import org.embeddedt.embeddium.gui.frame.BasicFrame;
import org.embeddedt.embeddium.gui.frame.components.SearchTextFieldComponent;
import org.embeddedt.embeddium.gui.frame.components.SearchTextFieldModel;
import org.embeddedt.embeddium.gui.frame.tab.Tab;
import org.embeddedt.embeddium.gui.frame.tab.TabFrame;
import org.embeddedt.embeddium.gui.screen.PromptScreen;
import org.embeddedt.embeddium.render.ShaderModBridge;
import org.embeddedt.embeddium.util.PlatformUtil;

public class EmbeddiumVideoOptionsScreen
extends class_437 {
    private static final class_2960 LOGO_LOCATION = new class_2960("embeddium", "textures/embeddium/gui/logo_transparent.png");
    private static final int LOGO_SIZE = 256;
    private static final AtomicReference<class_2561> tabFrameSelectedTab = new AtomicReference<Object>(null);
    private final AtomicReference<Integer> tabFrameScrollBarOffset = new AtomicReference<Integer>(0);
    private final AtomicReference<Integer> optionPageScrollBarOffset = new AtomicReference<Integer>(0);
    private final class_437 prevScreen;
    private final List<OptionPage> pages = new ArrayList<OptionPage>();
    private AbstractFrame frame;
    private FlatButtonWidget applyButton;
    private FlatButtonWidget closeButton;
    private FlatButtonWidget undoButton;
    private FlatButtonWidget donateButton;
    private FlatButtonWidget hideDonateButton;
    private Dim2i logoDim;
    private boolean hasPendingChanges;
    private SearchTextFieldComponent searchTextField;
    private final SearchTextFieldModel searchTextModel;
    private boolean firstInit = true;
    private static final float ASPECT_RATIO = 1.25f;
    private static final int MINIMUM_WIDTH = 550;

    public EmbeddiumVideoOptionsScreen(class_437 prev, List<OptionPage> pages) {
        super((class_2561)class_2561.method_43470((String)"Embeddium Options"));
        this.prevScreen = prev;
        this.pages.addAll(pages);
        this.searchTextModel = new SearchTextFieldModel(this.pages, this);
        this.registerTextures();
    }

    private void checkPromptTimers() {
        Instant threshold;
        if (PlatformUtil.isDevelopmentEnvironment()) {
            return;
        }
        SodiumGameOptions options = SodiumClientMod.options();
        if (options.notifications.forceDisableDonationPrompts || options.notifications.hasSeenDonationPrompt) {
            return;
        }
        HashedFingerprint fingerprint = null;
        try {
            fingerprint = HashedFingerprint.loadFromDisk();
        }
        catch (Throwable t) {
            SodiumClientMod.logger().error("Failed to read the fingerprint from disk", t);
        }
        if (fingerprint == null) {
            return;
        }
        Instant now = Instant.now();
        if (now.isAfter(threshold = Instant.ofEpochSecond(fingerprint.timestamp()).plus(3L, ChronoUnit.DAYS))) {
            this.openDonationPrompt();
            options.notifications.hasSeenDonationPrompt = true;
            try {
                SodiumGameOptions.writeToDisk(options);
            }
            catch (IOException e) {
                SodiumClientMod.logger().error("Failed to update config file", (Throwable)e);
            }
        }
    }

    private void openDonationPrompt() {
        PromptScreen prompt = new PromptScreen(this, SodiumOptionsGUI.DONATION_PROMPT_MESSAGE, 320, 190, new PromptScreen.Action((class_2561)class_2561.method_43470((String)"Support Sodium"), this::openDonationPage));
        this.field_22787.method_1507((class_437)prompt);
    }

    private void registerTextures() {
        class_310.method_1551().method_1531().method_4616(LOGO_LOCATION, (class_1044)new class_1049(LOGO_LOCATION));
    }

    public void rebuildUI() {
        boolean wasSearchFocused = this.searchTextField.method_25370();
        this.method_41843();
        if (wasSearchFocused) {
            this.method_25395(this.searchTextField);
        }
    }

    protected void method_25426() {
        this.frame = this.parentFrameBuilder().build();
        this.method_37063(this.frame);
        this.method_25395(this.frame);
        if (this.firstInit) {
            this.method_25395(this.searchTextField);
            this.firstInit = false;
            this.checkPromptTimers();
        }
    }

    protected BasicFrame.Builder parentFrameBuilder() {
        int newWidth = this.field_22789;
        if (newWidth > 550 && (float)this.field_22789 / (float)this.field_22790 > 1.25f) {
            newWidth = Math.max(550, (int)((float)this.field_22790 * 1.25f));
        }
        Dim2i basicFrameDim = new Dim2i((this.field_22789 - newWidth) / 2, 0, newWidth, this.field_22790);
        Dim2i tabFrameDim = new Dim2i(basicFrameDim.x() + basicFrameDim.width() / 20 / 2, basicFrameDim.y() + basicFrameDim.height() / 4 / 2, basicFrameDim.width() - basicFrameDim.width() / 20, basicFrameDim.height() / 4 * 3);
        Dim2i undoButtonDim = new Dim2i(tabFrameDim.getLimitX() - 203, tabFrameDim.getLimitY() + 5, 65, 20);
        Dim2i applyButtonDim = new Dim2i(tabFrameDim.getLimitX() - 134, tabFrameDim.getLimitY() + 5, 65, 20);
        Dim2i closeButtonDim = new Dim2i(tabFrameDim.getLimitX() - 65, tabFrameDim.getLimitY() + 5, 65, 20);
        class_5250 donationText = class_2561.method_43471((String)"sodium.options.buttons.donate");
        int donationTextWidth = this.field_22787.field_1772.method_27525((class_5348)donationText);
        Dim2i donateButtonDim = new Dim2i(tabFrameDim.getLimitX() - 32 - donationTextWidth, tabFrameDim.y() - 26, 10 + donationTextWidth, 20);
        Dim2i hideDonateButtonDim = new Dim2i(tabFrameDim.getLimitX() - 20, tabFrameDim.y() - 26, 20, 20);
        int logoSizeOnScreen = 20;
        this.logoDim = new Dim2i(tabFrameDim.x(), tabFrameDim.getLimitY() + 25 - logoSizeOnScreen, logoSizeOnScreen, logoSizeOnScreen);
        this.undoButton = new FlatButtonWidget(undoButtonDim, (class_2561)class_2561.method_43471((String)"sodium.options.buttons.undo"), this::undoChanges);
        this.applyButton = new FlatButtonWidget(applyButtonDim, (class_2561)class_2561.method_43471((String)"sodium.options.buttons.apply"), this::applyChanges);
        this.closeButton = new FlatButtonWidget(closeButtonDim, (class_2561)class_2561.method_43471((String)"gui.done"), this::method_25419);
        this.donateButton = new FlatButtonWidget(donateButtonDim, (class_2561)donationText, this::openDonationPage);
        this.hideDonateButton = new FlatButtonWidget(hideDonateButtonDim, (class_2561)class_2561.method_43470((String)"x"), this::hideDonationButton);
        if (SodiumClientMod.options().notifications.hasClearedDonationButton) {
            this.setDonationButtonVisibility(false);
        }
        Dim2i searchTextFieldDim = SodiumClientMod.options().notifications.hasClearedDonationButton ? new Dim2i(tabFrameDim.x(), tabFrameDim.y() - 26, tabFrameDim.width(), 20) : new Dim2i(tabFrameDim.x(), tabFrameDim.y() - 26, tabFrameDim.width() - (tabFrameDim.getLimitX() - donateButtonDim.x()) - 2, 20);
        BasicFrame.Builder basicFrameBuilder = this.parentBasicFrameBuilder(basicFrameDim, tabFrameDim);
        this.searchTextField = new SearchTextFieldComponent(searchTextFieldDim, this.pages, this.searchTextModel);
        basicFrameBuilder.addChild(dim -> this.searchTextField);
        return basicFrameBuilder;
    }

    private boolean canShowPage(OptionPage page) {
        if (page.getGroups().isEmpty()) {
            return false;
        }
        Predicate<Option<?>> predicate = this.searchTextModel.getOptionPredicate();
        for (OptionGroup group : page.getGroups()) {
            for (Option option : group.getOptions()) {
                if (!predicate.test(option)) continue;
                return true;
            }
        }
        return false;
    }

    private void createShaderPackButton(Multimap<String, Tab<?>> tabs) {
        if (this.searchTextModel.getOptionPredicate().test(null) && ShaderModBridge.isShaderModPresent()) {
            String shaderModId = Stream.of("oculus", "iris").filter(PlatformUtil::modPresent).findFirst().orElse("iris");
            tabs.put((Object)shaderModId, Tab.createBuilder().setTitle((class_2561)class_2561.method_43471((String)"options.iris.shaderPackSelection")).setId(OptionIdentifier.create("iris", "shader_packs")).setOnSelectFunction(() -> {
                Object patt0$temp = ShaderModBridge.openShaderScreen(this);
                if (patt0$temp instanceof class_437) {
                    class_437 screen = (class_437)patt0$temp;
                    this.field_22787.method_1507(screen);
                }
                return false;
            }).build());
        }
    }

    private AbstractFrame createTabFrame(Dim2i tabFrameDim) {
        return TabFrame.createBuilder().setDimension(tabFrameDim).shouldRenderOutline(false).setTabSectionScrollBarOffset(this.tabFrameScrollBarOffset).setTabSectionSelectedTab(tabFrameSelectedTab).addTabs(tabs -> this.pages.stream().filter(this::canShowPage).forEach(page -> tabs.put((Object)page.getId().getModId(), Tab.createBuilder().from((OptionPage)page, this.searchTextModel.getOptionPredicate(), this.optionPageScrollBarOffset)))).addTabs(this::createShaderPackButton).onSetTab(() -> this.optionPageScrollBarOffset.set(0)).build();
    }

    public BasicFrame.Builder parentBasicFrameBuilder(Dim2i parentBasicFrameDim, Dim2i tabFrameDim) {
        return BasicFrame.createBuilder().setDimension(parentBasicFrameDim).shouldRenderOutline(false).addChild(dim -> this.donateButton).addChild(dim -> this.hideDonateButton).addChild(parentDim -> this.createTabFrame(tabFrameDim)).addChild(dim -> this.undoButton).addChild(dim -> this.applyButton).addChild(dim -> this.closeButton);
    }

    public void method_25420(class_332 gfx) {
        super.method_25420(gfx);
        gfx.method_51422((float)ColorARGB.unpackRed(-3179338) / 255.0f, (float)ColorARGB.unpackGreen(-3179338) / 255.0f, (float)ColorARGB.unpackBlue(-3179338) / 255.0f, 0.8f);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        gfx.method_25293(LOGO_LOCATION, this.logoDim.x(), this.logoDim.y(), this.logoDim.width(), this.logoDim.height(), 0.0f, 0.0f, 256, 256, 256, 256);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        gfx.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        this.method_25420(drawContext);
        this.updateControls();
        this.frame.method_25394(drawContext, mouseX, mouseY, delta);
    }

    private void updateControls() {
        boolean hasChanges = this.getAllOptions().anyMatch(Option::hasChanged);
        for (OptionPage page : this.pages) {
            for (Option option : page.getOptions()) {
                if (!option.hasChanged()) continue;
                hasChanges = true;
            }
        }
        this.applyButton.setEnabled(hasChanges);
        this.undoButton.setVisible(hasChanges);
        this.closeButton.setEnabled(!hasChanges);
        this.hasPendingChanges = hasChanges;
    }

    private void setDonationButtonVisibility(boolean value) {
        this.donateButton.setVisible(value);
        this.hideDonateButton.setVisible(value);
    }

    private void hideDonationButton() {
        SodiumGameOptions options = SodiumClientMod.options();
        options.notifications.hasClearedDonationButton = true;
        try {
            SodiumGameOptions.writeToDisk(options);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save configuration", e);
        }
        this.setDonationButtonVisibility(false);
        this.rebuildUI();
    }

    private void openDonationPage() {
        class_156.method_668().method_670("https://caffeinemc.net/donate");
    }

    private Stream<Option<?>> getAllOptions() {
        return this.pages.stream().flatMap(s -> s.getOptions().stream());
    }

    private void applyChanges() {
        HashSet dirtyStorages = new HashSet();
        EnumSet<OptionFlag> flags = EnumSet.noneOf(OptionFlag.class);
        this.getAllOptions().forEach(option -> {
            if (!option.hasChanged()) {
                return;
            }
            option.applyChanges();
            flags.addAll(option.getFlags());
            dirtyStorages.add(option.getStorage());
        });
        class_310 client = class_310.method_1551();
        if (client.field_1687 != null) {
            if (flags.contains((Object)OptionFlag.REQUIRES_RENDERER_RELOAD)) {
                client.field_1769.method_3279();
            } else if (flags.contains((Object)OptionFlag.REQUIRES_RENDERER_UPDATE)) {
                client.field_1769.method_3292();
            }
        }
        if (flags.contains((Object)OptionFlag.REQUIRES_ASSET_RELOAD)) {
            client.method_24041(((Integer)client.field_1690.method_42563().method_41753()).intValue());
            client.method_1513();
        }
        if (flags.contains((Object)OptionFlag.REQUIRES_GAME_RESTART)) {
            Console.instance().logMessage(MessageLevel.WARN, (class_2561)class_2561.method_43471((String)"sodium.console.game_restart"), 10.0);
        }
        for (OptionStorage storage : dirtyStorages) {
            storage.save();
        }
    }

    private void undoChanges() {
        this.getAllOptions().forEach(Option::reset);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!(keyCode != 80 || (modifiers & 1) == 0 || this.searchTextField != null && this.searchTextField.method_25370())) {
            class_310.method_1551().method_1507((class_437)new class_446(this.prevScreen, class_310.method_1551().field_1690));
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25422() {
        return !this.hasPendingChanges;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.prevScreen);
    }
}

