/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.guicompass_common_forge.events;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.natamus.collective_common_forge.functions.GUIFunctions;
import com.natamus.guicompass_common_forge.config.ConfigHandler;
import com.natamus.guicompass_common_forge.util.Util;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;

public class GUIEvent {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final List<String> direction = Arrays.asList("S", "SW", "W", "NW", "N", "NE", "E", "SE", "S");

    public static void renderOverlay(GuiGraphics guiGraphics, float tickDelta) {
        if (GUIFunctions.shouldHideGUI()) {
            return;
        }
        if (ConfigHandler.mustHaveCompassInInventory) {
            boolean found = Util.isCompass(GUIEvent.mc.f_91074_.m_21206_());
            if (!found) {
                Inventory inv = GUIEvent.mc.f_91074_.m_150109_();
                for (int n = 0; n <= 35; ++n) {
                    if (!Util.isCompass(inv.m_8020_(n))) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                return;
            }
        }
        String coordinates = GUIEvent.getCoordinates();
        Font fontRenderer = GUIEvent.mc.f_91062_;
        Window scaled = mc.m_91268_();
        int width = scaled.m_85445_();
        int stringWidth = fontRenderer.m_92895_(coordinates);
        Color colour = new Color(ConfigHandler.RGB_R, ConfigHandler.RGB_G, ConfigHandler.RGB_B, 255);
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        int xcoord = ConfigHandler.compassPositionIsLeft ? 5 : (ConfigHandler.compassPositionIsCenter ? width / 2 - stringWidth / 2 : width - stringWidth - 5);
        GUIEvent.drawText(fontRenderer, guiGraphics, coordinates, xcoord, ConfigHandler.compassHeightOffset, colour.getRGB(), ConfigHandler.drawTextShadow);
        poseStack.m_85849_();
    }

    private static void drawText(Font font, GuiGraphics guiGraphics, String content, int x, int y, int rgb, boolean drawShadow) {
        guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)content), x, y, rgb, drawShadow);
    }

    private static String getCoordinates() {
        Entity player = mc.m_91288_();
        BlockPos ppos = player.m_20183_();
        String format = ConfigHandler.guiCompassFormat;
        Object toshow = "";
        if (format.contains("F")) {
            float degrees = Mth.m_14177_((float)player.m_146908_());
            if (degrees < 0.0f) {
                degrees += 360.0f;
            }
            int facing = Math.round(degrees / 45.0f);
            toshow = (String)toshow + direction.get(facing) + ": ";
        }
        if (format.contains("X")) {
            toshow = (String)toshow + ppos.m_123341_() + ", ";
        }
        if (format.contains("Y")) {
            toshow = (String)toshow + ppos.m_123342_() + ", ";
        }
        if (format.contains("Z")) {
            toshow = (String)toshow + ppos.m_123343_() + ", ";
        }
        if (((String)toshow).length() < 2) {
            return "";
        }
        return ((String)toshow).substring(0, ((String)toshow).length() - 2);
    }
}

