/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.displaystate.render;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.darkhax.botanypots.data.displaystate.AgingDisplayState;
import net.darkhax.botanypots.data.displaystate.DisplayState;
import net.darkhax.botanypots.data.displaystate.SimpleDisplayState;
import net.darkhax.botanypots.data.displaystate.TransitionalDisplayState;
import net.darkhax.botanypots.data.displaystate.render.AgingDisplayStateRenderer;
import net.darkhax.botanypots.data.displaystate.render.SimpleDisplayStateRenderer;
import net.darkhax.botanypots.data.displaystate.render.TransitionalDisplayStateRenderer;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public abstract class DisplayStateRenderer<T extends DisplayState> {
    private static final Map<class_2960, DisplayStateRenderer<DisplayState>> RENDERERS = new HashMap<class_2960, DisplayStateRenderer<DisplayState>>();

    public static DisplayStateRenderer<DisplayState> getRenderer(DisplayState state) {
        DisplayStateRenderer<DisplayState> renderer = DisplayStateRenderer.getRenderer(state.getSerializer().getId());
        if (renderer != null) {
            return renderer;
        }
        throw new IllegalStateException("Display state " + state.getSerializer().getId() + " is not bound to a renderer.");
    }

    public static void renderState(DisplayState displayState, class_4587 stack, class_1937 level, class_2338 pos, class_4597 bufferSource, int light, int overlay, float progress) {
        DisplayStateRenderer.getRenderer(displayState).render(displayState, stack, level, pos, bufferSource, light, overlay, progress);
    }

    @Nullable
    public static DisplayStateRenderer<DisplayState> getRenderer(class_2960 id) {
        return RENDERERS.get(id);
    }

    public abstract void render(T var1, class_4587 var2, class_1937 var3, class_2338 var4, class_4597 var5, int var6, int var7, float var8);

    public static void init() {
        RENDERERS.put(SimpleDisplayState.ID, SimpleDisplayStateRenderer.RENDERER);
        RENDERERS.put(TransitionalDisplayState.ID, TransitionalDisplayStateRenderer.RENDERER);
        RENDERERS.put(AgingDisplayState.ID, AgingDisplayStateRenderer.RENDERER);
    }
}

