/*
 * Decompiled with CFR 0.152.
 */
package obro1961.chatpatches.chatlog;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_338;
import net.minecraft.class_7591;
import obro1961.chatpatches.ChatPatches;
import obro1961.chatpatches.util.Flags;
import obro1961.chatpatches.util.SharedVariables;

public class ChatLog {
    public static final String CHATLOG_PATH = SharedVariables.FABRIC_LOADER.getGameDir().toString() + File.separator + "logs" + File.separator + "chatlog.json";
    private static final Path file = Path.of(CHATLOG_PATH, new String[0]);
    private static final Gson json = new GsonBuilder().registerTypeAdapter(class_2561.class, (src, type, context) -> class_2561.class_2562.method_10868((class_2561)src)).registerTypeAdapter(class_2561.class, (json, type, context) -> class_2561.class_2562.method_10872((JsonElement)json)).registerTypeAdapter(class_2561.class, type -> class_2561.method_43473()).create();
    private static boolean savedAfterCrash = false;
    private static Data data = new Data();
    public static boolean loaded = false;

    public static void deserialize() {
        String rawData = "{\"history\":[],\"messages\":[]}";
        if (Files.exists(file, new LinkOption[0])) {
            try {
                rawData = Files.readString(file);
            }
            catch (MalformedInputException notUTF8) {
                ChatPatches.LOGGER.warn("[ChatLog.deserialize] ChatLog file encoding was '{}', not UTF-8. Complex text characters may have been replaced with question marks.", (Object)Charset.defaultCharset().name());
                try {
                    Files.writeString(file, (CharSequence)new String(Files.readAllBytes(file)), StandardOpenOption.TRUNCATE_EXISTING);
                    rawData = Files.readString(file);
                }
                catch (IOException ioexc) {
                    ChatPatches.LOGGER.error("[ChatLog.deserialize] Couldn't rewrite the ChatLog at '{}', resetting:", (Object)CHATLOG_PATH, (Object)ioexc);
                    try {
                        rawData = "{\"history\":[],\"messages\":[]}";
                        Files.writeString(file, (CharSequence)"{\"history\":[],\"messages\":[]}", StandardOpenOption.TRUNCATE_EXISTING);
                    }
                    catch (IOException ioerr) {
                        ChatPatches.LOGGER.error("[ChatLog.deserialize] Couldn't reset the ChatLog at '{}':", (Object)CHATLOG_PATH, (Object)ioerr);
                    }
                }
            }
            catch (IOException e) {
                ChatPatches.LOGGER.error("[ChatLog.deserialize] Couldn't access the ChatLog at '{}':", (Object)CHATLOG_PATH, (Object)e);
            }
        } else {
            data = new Data();
            loaded = true;
            return;
        }
        if (rawData.length() < 2 || !rawData.startsWith("{")) {
            data = new Data();
            loaded = true;
            return;
        }
        try {
            data = (Data)json.fromJson(rawData, Data.class);
            ChatLog.enforceSizes();
        }
        catch (JsonSyntaxException e) {
            ChatPatches.LOGGER.error("[ChatLog.deserialize] Tried to read the ChatLog and found an error, loading an empty one: ", (Throwable)e);
            data = new Data();
            loaded = true;
            return;
        }
        loaded = true;
        ChatPatches.LOGGER.info("[ChatLog.deserialize] Read the chat log containing {} messages and {} sent messages from '{}'", new Object[]{ChatLog.data.messages.size(), ChatLog.data.history.size(), CHATLOG_PATH});
    }

    public static void serialize(boolean crashing) {
        if (crashing && savedAfterCrash) {
            return;
        }
        try {
            ChatLog.enforceSizes();
            String str = json.toJson((Object)data, Data.class);
            Files.writeString(file, (CharSequence)str, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            ChatPatches.LOGGER.info("[ChatLog.serialize] Saved the chat log containing {} messages and {} sent messages to '{}'", new Object[]{ChatLog.data.messages.size(), ChatLog.data.history.size(), CHATLOG_PATH});
        }
        catch (IOException e) {
            ChatPatches.LOGGER.error("[ChatLog.serialize] An I/O error occurred while trying to save the chat log:", (Throwable)e);
        }
        finally {
            if (crashing) {
                savedAfterCrash = true;
            }
        }
    }

    private static void enforceSizes() {
        int oldHistorySize;
        int oldMessageSize = ChatLog.data.messages.size();
        if (oldMessageSize > ChatPatches.config.chatMaxMessages) {
            ChatLog.data.messages = ChatLog.data.messages.subList(0, ChatPatches.config.chatMaxMessages + 1);
            ChatPatches.LOGGER.warn("[ChatLog.enforceSizes] ChatLog was full, trimmed to {} messages (removed {})", (Object)ChatPatches.config.chatMaxMessages, (Object)(oldMessageSize - ChatPatches.config.chatMaxMessages));
        }
        if ((oldHistorySize = ChatLog.data.history.size()) > ChatPatches.config.chatMaxMessages) {
            ChatLog.data.history = ChatLog.data.history.subList(0, ChatPatches.config.chatMaxMessages + 1);
            ChatPatches.LOGGER.warn("[ChatLog.enforceSizes] ChatLog was full, trimmed to {} sent messages (removed {})", (Object)ChatPatches.config.chatMaxMessages, (Object)(oldHistorySize - ChatPatches.config.chatMaxMessages));
        }
    }

    public static void restore(class_310 client) {
        Flags.LOADING_CHATLOG.raise();
        if (!ChatLog.data.history.isEmpty()) {
            ChatLog.data.history.forEach(arg_0 -> ((class_338)client.field_1705.method_1743()).method_1803(arg_0));
        }
        if (!ChatLog.data.messages.isEmpty()) {
            ChatLog.data.messages.forEach(msg -> client.field_1705.method_1743().method_44811(msg, null, new class_7591(3682229, null, null, "Restored")));
        }
        Flags.LOADING_CHATLOG.lower();
        ChatPatches.LOGGER.info("[ChatLog.restore] Restored {} messages and {} history messages from '{}' into Minecraft!", new Object[]{ChatLog.data.messages.size(), ChatLog.data.history.size(), CHATLOG_PATH});
    }

    public static void addMessage(class_2561 msg) {
        if (ChatLog.data.messages.size() < ChatPatches.config.chatMaxMessages) {
            ChatLog.data.messages.add(msg);
        } else {
            ChatPatches.LOGGER.warn("[ChatLog.addMessage] ChatLog message capacity has been reached, ignoring message '{}'", (Object)msg.getString());
        }
    }

    public static void addHistory(String msg) {
        if (ChatLog.data.history.size() < ChatPatches.config.chatMaxMessages) {
            ChatLog.data.history.add(msg);
        } else {
            ChatPatches.LOGGER.warn("[ChatLog.addMessage] ChatLog history capacity has been reached, ignoring sent message '{}'", (Object)msg);
        }
    }

    public static void clearMessages() {
        ChatLog.data.messages.clear();
    }

    public static void clearHistory() {
        ChatLog.data.history.clear();
    }

    private static class Data {
        public static final String EMPTY_DATA = "{\"history\":[],\"messages\":[]}";
        public static final int DEFAULT_SIZE = 100;
        public List<class_2561> messages = Lists.newArrayListWithExpectedSize((int)100);
        public List<String> history = Lists.newArrayListWithExpectedSize((int)100);

        private Data() {
        }
    }
}

