/*
 * Decompiled with CFR 0.152.
 */
package obro1961.chatpatches.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1299;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import obro1961.chatpatches.ChatPatches;
import obro1961.chatpatches.config.YACLConfig;
import obro1961.chatpatches.util.SharedVariables;
import obro1961.chatpatches.util.StringTextUtils;

public class Config {
    public static final String CONFIG_PATH = SharedVariables.FABRIC_LOADER.getConfigDir().toString() + File.separator + "chatpatches.json";
    private static final Config DEFAULTS = new Config();
    public boolean time = true;
    public String timeDate = "HH:mm:ss";
    public String timeFormat = "[$]";
    public int timeColor = 0xFF55FF;
    public boolean hover = true;
    public String hoverDate = "MM/dd/yyyy";
    public String hoverFormat = "$";
    public int hoverColor = 0xFFFFFF;
    public boolean counter = true;
    public String counterFormat = "&8(&7x&r$&8)";
    public int counterColor = 0xFFFF55;
    public boolean counterCompact = false;
    public int counterCompactDistance = 0;
    public boolean boundary = true;
    public String boundaryFormat = "&8[&r$&8]";
    public int boundaryColor = 0x55FFFF;
    public boolean chatLog = true;
    public boolean chatHidePacket = true;
    public int chatWidth = 0;
    public int chatMaxMessages = 16384;
    public String chatNameFormat = "<$>";
    public int shiftChat = 10;
    public boolean messageDrafting = false;
    public boolean searchDrafting = true;
    public boolean hideSearchButton = false;
    public boolean vanillaClearing = false;
    public int copyColor = 0x55FFFF;
    public String copyReplyFormat = "/msg $ ";

    public static Config newConfig(boolean reset) {
        FabricLoader fbr = FabricLoader.getInstance();
        boolean accessibleInGame = fbr.isModLoaded("modmenu") || fbr.isModLoaded("catalogue") && fbr.isModLoaded("menulogue");
        Config config = ChatPatches.config = accessibleInGame ? new YACLConfig() : DEFAULTS;
        if (!reset) {
            Config.read();
        }
        Config.write();
        return ChatPatches.config;
    }

    public class_437 getConfigScreen(class_437 parent) {
        return null;
    }

    public static List<ConfigOption<?>> getOptions() {
        ArrayList options = new ArrayList(Config.class.getDeclaredFields().length);
        for (Field field : Config.class.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            options.add(Config.getOption(field.getName()));
        }
        return options;
    }

    public static <T> ConfigOption<T> getOption(String key) {
        try {
            return new ConfigOption<Object>(ChatPatches.config.getClass().getField(key).get(ChatPatches.config), Config.class.getField(key).get(DEFAULTS), key);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            ChatPatches.LOGGER.error("[Config.getOption({})] An error occurred while trying to get an option value, please report this on GitHub:", (Object)key, (Object)e);
            return new ConfigOption<Object>(new Object(), new Object(), key);
        }
    }

    public class_5250 makeTimestamp(Date when) {
        return StringTextUtils.toText(StringTextUtils.fillVars(this.timeFormat, new SimpleDateFormat(this.timeDate).format(when)) + " ").method_27696(class_2583.field_24360.method_36139(this.timeColor));
    }

    public class_2583 makeHoverStyle(Date when) {
        class_2583 EMPTY = class_2583.field_24360.method_10982(Boolean.valueOf(false)).method_10978(Boolean.valueOf(false)).method_30938(Boolean.valueOf(false)).method_36141(Boolean.valueOf(false)).method_36140(Boolean.valueOf(false));
        class_5250 hoverText = StringTextUtils.toText(StringTextUtils.fillVars(this.hoverFormat, new SimpleDateFormat(this.hoverDate).format(when))).method_27696(EMPTY.method_36139(this.hoverColor));
        return EMPTY.method_10949(this.hover ? new class_2568(class_2568.class_5247.field_24342, (Object)hoverText) : null).method_10958(this.hover ? new class_2558(class_2558.class_2559.field_11745, hoverText.getString()) : null).method_10975(String.valueOf(when.getTime())).method_36139(this.timeColor);
    }

    public class_5250 formatPlayername(GameProfile player) {
        String name = player.getName();
        return StringTextUtils.toText(StringTextUtils.fillVars(this.chatNameFormat, name) + " ").method_10862(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24344, (Object)new class_2568.class_5248(class_1299.field_6097, player.getId(), class_2561.method_30163((String)player.getName())))).method_10958(new class_2558(class_2558.class_2559.field_11745, "/tell " + name + " ")));
    }

    public class_5250 makeDupeCounter(int dupes) {
        return StringTextUtils.toText(" " + StringTextUtils.fillVars(this.counterFormat, Integer.toString(dupes))).method_27696(class_2583.field_24360.method_36139(this.counterColor));
    }

    public class_2561 makeBoundaryLine(String levelName) {
        return class_2561.method_43473().method_10852((class_2561)StringTextUtils.toText(StringTextUtils.fillVars(this.boundaryFormat, levelName)).method_27696(class_2583.field_24360.method_36139(this.boundaryColor))).method_10852((class_2561)class_2561.method_43473());
    }

    public static void read() {
        if (!Files.exists(Path.of(CONFIG_PATH, new String[0]), new LinkOption[0])) {
            ChatPatches.config = Config.newConfig(true);
        } else {
            try (FileReader fr = new FileReader(CONFIG_PATH);){
                ChatPatches.config = (Config)new Gson().fromJson((Reader)fr, ChatPatches.config.getClass());
                ChatPatches.LOGGER.info("[Config.read] Loaded config info from '{}'!", (Object)CONFIG_PATH);
            }
            catch (JsonIOException | JsonSyntaxException e) {
                ChatPatches.LOGGER.info("[Config.read] The config couldn't be loaded; copying old data and resetting...");
                Config.writeCopy();
                Config.reset();
            }
            catch (IOException e) {
                Config.reset();
                ChatPatches.LOGGER.error("[Config.read] An error occurred while trying to load config data from '{}':", (Object)CONFIG_PATH, (Object)e);
            }
        }
    }

    public static void write() {
        try (FileWriter fw = new FileWriter(CONFIG_PATH);){
            new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).setPrettyPrinting().create().toJson((Object)ChatPatches.config, ChatPatches.config.getClass(), (Appendable)fw);
            ChatPatches.LOGGER.info("[Config.write] Saved config info to '{}'!", (Object)CONFIG_PATH);
        }
        catch (Exception e) {
            ChatPatches.LOGGER.error("[Config.write] An error occurred while trying to save config data to '{}':", (Object)CONFIG_PATH, (Object)e);
        }
    }

    public static void reset() {
        ChatPatches.config = Config.newConfig(true);
    }

    public static void writeCopy() {
        try (FileInputStream cfg = new FileInputStream(CONFIG_PATH);
             FileOutputStream copy = new FileOutputStream(CONFIG_PATH.replace("chatpatches", "chatpatches_old"));){
            copy.write(cfg.readAllBytes());
        }
        catch (IOException e) {
            ChatPatches.LOGGER.error("[Config.writeCopy] An error occurred trying to copy the original config file from '{}':", (Object)CONFIG_PATH, (Object)e);
        }
    }

    public static class ConfigOption<T> {
        private T val;
        public final T def;
        public final String key;

        public ConfigOption(T val, T def, String key) {
            this.val = Objects.requireNonNull(val, "Cannot create a ConfigOption without a default value");
            this.def = Objects.requireNonNull(def, "Cannot create a ConfigOption without a default value");
            this.key = Objects.requireNonNull(key, "Cannot create a ConfigOption without a key");
        }

        public T get() {
            return this.val;
        }

        public Class<T> getType() {
            return this.def.getClass();
        }

        public void set(Object obj, boolean set) {
            try {
                Object inc = obj;
                if (inc != null && !inc.equals(this.val) && set) {
                    ChatPatches.config.getClass().getField(this.key).set(ChatPatches.config, inc);
                    this.val = inc;
                }
            }
            catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
                ChatPatches.LOGGER.error("[ConfigOption.set({})] An error occurred trying to set a config option:", obj, (Object)e);
            }
        }

        public void set(Object obj) {
            this.set(obj, true);
        }

        public boolean changed() {
            return !this.val.equals(this.def);
        }
    }
}

