/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import net.minecraft.class_1074;
import net.minecraft.class_241;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Identifiers;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.Element;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.IconUI;

public class HealthElement
extends Element {
    private final float maxHealth;
    private final float health;
    private String text;

    public HealthElement(float maxHealth, float health) {
        if (!PluginConfig.INSTANCE.get(Identifiers.MC_ENTITY_HEALTH_SHOW_FRACTIONS)) {
            maxHealth = class_3532.method_15386((float)maxHealth);
            health = class_3532.method_15386((float)health);
        }
        this.maxHealth = maxHealth;
        this.health = health;
        this.text = String.format("  %s/%s", DisplayHelper.dfCommas.format(health), DisplayHelper.dfCommas.format(maxHealth));
    }

    @Override
    public class_241 getSize() {
        if (this.maxHealth > (float)PluginConfig.INSTANCE.getInt(Identifiers.MC_ENTITY_HEALTH_MAX_FOR_RENDER)) {
            return new class_241((float)(8 + DisplayHelper.font().method_1727(this.text)), 10.0f);
        }
        float maxHearts = PluginConfig.INSTANCE.getInt(Identifiers.MC_ENTITY_HEALTH_ICONS_PER_LINE);
        float maxHealth = this.maxHealth * 0.5f;
        int heartsPerLine = (int)Math.min((double)maxHearts, Math.ceil(maxHealth));
        int lineCount = (int)Math.ceil(maxHealth / maxHearts);
        return new class_241((float)(8 * heartsPerLine), (float)(10 * lineCount));
    }

    @Override
    public void render(class_332 guiGraphics, float x, float y, float maxX, float maxY) {
        float maxHearts = PluginConfig.INSTANCE.getInt(Identifiers.MC_ENTITY_HEALTH_ICONS_PER_LINE);
        int maxHeartsForRender = PluginConfig.INSTANCE.getInt(Identifiers.MC_ENTITY_HEALTH_MAX_FOR_RENDER);
        boolean showNumbers = this.maxHealth > (float)maxHeartsForRender;
        int heartCount = showNumbers ? 1 : class_3532.method_15386((float)(this.maxHealth * 0.5f));
        float health = showNumbers ? 1.0f : this.health * 0.5f;
        int heartsPerLine = (int)Math.min((double)maxHearts, Math.ceil(this.maxHealth));
        int xOffset = 0;
        for (int i = 1; i <= heartCount; ++i) {
            if (i <= class_3532.method_15375((float)health)) {
                DisplayHelper.renderIcon(guiGraphics, x + (float)xOffset, y, 8, 8, IconUI.HEART);
                xOffset += 8;
            }
            if ((float)i > health && (float)i < health + 1.0f) {
                DisplayHelper.renderIcon(guiGraphics, x + (float)xOffset, y, 8, 8, IconUI.HALF_HEART);
                xOffset += 8;
            }
            if ((float)i >= health + 1.0f) {
                DisplayHelper.renderIcon(guiGraphics, x + (float)xOffset, y, 8, 8, IconUI.EMPTY_HEART);
                xOffset += 8;
            }
            if (showNumbers || i % heartsPerLine != 0) continue;
            y += 10.0f;
            xOffset = 0;
        }
        if (showNumbers) {
            DisplayHelper.INSTANCE.drawText(guiGraphics, this.text, x + 8.0f, y, IThemeHelper.get().getNormalColor());
        }
    }

    @Override
    @Nullable
    public String getMessage() {
        return class_1074.method_4662((String)"narration.jade.health", (Object[])new Object[]{DisplayHelper.dfCommas.format(this.health)});
    }
}

