/*
 * Decompiled with CFR 0.152.
 */
package dev.notalpha.dashloader.io;

import com.github.luben.zstd.Zstd;
import dev.notalpha.taski.builtin.StepTask;
import dev.quantumfusion.hyphen.io.ByteBufferIO;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.lwjgl.system.MemoryUtil;

public final class IOHelper {
    public static int[] toArray(IntBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        buffer.rewind();
        int[] foo = new int[buffer.remaining()];
        buffer.get(foo);
        return foo;
    }

    public static float[] toArray(FloatBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        buffer.rewind();
        float[] foo = new float[buffer.remaining()];
        buffer.get(foo);
        return foo;
    }

    public static IntBuffer fromArray(int[] arr) {
        if (arr == null) {
            return null;
        }
        IntBuffer buffer = MemoryUtil.memAllocInt((int)arr.length);
        buffer.put(arr);
        buffer.rewind();
        return buffer;
    }

    public static FloatBuffer fromArray(float[] arr) {
        if (arr == null) {
            return null;
        }
        FloatBuffer buffer = MemoryUtil.memAllocFloat((int)arr.length);
        buffer.put(arr);
        buffer.rewind();
        return buffer;
    }

    public static void save(Path path, StepTask task, ByteBufferIO io, int fileSize, byte compressionLevel) throws IOException {
        io.rewind();
        io.byteBuffer.limit(fileSize);
        try (FileChannel channel = IOHelper.createFile(path);){
            if (compressionLevel > 0) {
                task.reset(4);
                long maxSize = Zstd.compressBound((long)fileSize);
                ByteBufferIO dst = ByteBufferIO.createDirect((int)((int)maxSize));
                task.next();
                long size = Zstd.compress((ByteBuffer)dst.byteBuffer, (ByteBuffer)io.byteBuffer, (int)compressionLevel);
                task.next();
                dst.rewind();
                dst.byteBuffer.limit((int)size);
                ByteBuffer map = channel.map(FileChannel.MapMode.READ_WRITE, 0L, size + 5L).order(ByteOrder.LITTLE_ENDIAN);
                task.next();
                map.put(compressionLevel);
                map.putInt(fileSize);
                map.put(dst.byteBuffer);
                io.close();
                dst.close();
            } else {
                task.reset(2);
                ByteBuffer map = channel.map(FileChannel.MapMode.READ_WRITE, 0L, fileSize + 1).order(ByteOrder.LITTLE_ENDIAN);
                task.next();
                ByteBufferIO file = ByteBufferIO.wrap((ByteBuffer)map);
                file.putByte(compressionLevel);
                file.putByteBuffer(io.byteBuffer, fileSize);
                task.next();
            }
        }
    }

    public static ByteBufferIO load(Path path) throws IOException {
        try (FileChannel channel = IOHelper.openFile(path);){
            ByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size()).order(ByteOrder.LITTLE_ENDIAN);
            if (buffer.get() > 0) {
                int size = buffer.getInt();
                ByteBufferIO dst = ByteBufferIO.createDirect((int)size);
                Zstd.decompress((ByteBuffer)dst.byteBuffer, (ByteBuffer)buffer);
                dst.rewind();
                ByteBufferIO byteBufferIO = dst;
                return byteBufferIO;
            }
            ByteBufferIO byteBufferIO = ByteBufferIO.wrap((ByteBuffer)buffer);
            return byteBufferIO;
        }
    }

    public static FileChannel createFile(Path path) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Files.deleteIfExists(path);
        return FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ);
    }

    public static FileChannel openFile(Path path) throws IOException {
        return FileChannel.open(path, StandardOpenOption.READ);
    }

    public static byte[] streamToArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream(){

            @Override
            public synchronized byte[] toByteArray() {
                return this.buf;
            }
        };
        IOUtils.copy((InputStream)inputStream, (OutputStream)output);
        return output.toByteArray();
    }
}

