/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.catalogue.client;

import com.mrcrayfish.catalogue.Catalogue;
import com.mrcrayfish.catalogue.client.IModData;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.apache.commons.lang3.StringUtils;

public class FabricModData
implements IModData {
    private final ModMetadata metadata;
    private final IModData.Type type;
    private final String imageIcon;
    private final String imageBanner;
    private final String imageBackground;
    private final String itemIcon;

    public FabricModData(ModMetadata metadata) {
        this.metadata = metadata;
        this.type = FabricModData.analyzeType(metadata);
        String imageIcon = metadata.getIconPath(64).orElse(null);
        String imageBanner = null;
        String imageBackground = null;
        String itemIcon = null;
        CustomValue value = metadata.getCustomValue("catalogue");
        if (value != null && value.getType() == CustomValue.CvType.OBJECT) {
            CustomValue backgroundValue;
            CustomValue bannerValue;
            CustomValue.CvObject catalogueObj = value.getAsObject();
            CustomValue iconValue = catalogueObj.get("icon");
            if (iconValue != null && iconValue.getType() == CustomValue.CvType.OBJECT) {
                CustomValue itemValue;
                CustomValue.CvObject iconObj = iconValue.getAsObject();
                CustomValue imageValue = iconObj.get("image");
                if (imageValue != null && imageValue.getType() == CustomValue.CvType.STRING) {
                    imageIcon = imageValue.getAsString();
                }
                if ((itemValue = iconObj.get("item")) != null && itemValue.getType() == CustomValue.CvType.STRING) {
                    itemIcon = itemValue.getAsString();
                }
            }
            if ((bannerValue = catalogueObj.get("banner")) != null && bannerValue.getType() == CustomValue.CvType.STRING) {
                imageBanner = bannerValue.getAsString();
            }
            if ((backgroundValue = catalogueObj.get("background")) != null && backgroundValue.getType() == CustomValue.CvType.STRING) {
                imageBackground = backgroundValue.getAsString();
            }
        }
        this.imageIcon = imageIcon;
        this.itemIcon = itemIcon;
        this.imageBanner = imageBanner;
        this.imageBackground = imageBackground;
    }

    @Override
    public IModData.Type getType() {
        return this.type;
    }

    @Override
    public String getModId() {
        return this.metadata.getId();
    }

    @Override
    public String getDisplayName() {
        return this.metadata.getName();
    }

    @Override
    public String getVersion() {
        return this.metadata.getVersion().getFriendlyString();
    }

    @Override
    public String getDescription() {
        return this.metadata.getDescription();
    }

    @Override
    @Nullable
    public String getItemIcon() {
        return this.itemIcon;
    }

    @Override
    @Nullable
    public String getImageIcon() {
        return this.imageIcon;
    }

    @Override
    public String getLicense() {
        return StringUtils.join((Iterable)this.metadata.getLicense(), (String)", ");
    }

    @Override
    @Nullable
    public String getCredits() {
        return StringUtils.join((Iterable)this.metadata.getContributors().stream().map(Person::getName).collect(Collectors.toList()), (String)", ");
    }

    @Override
    @Nullable
    public String getAuthors() {
        return StringUtils.join((Iterable)this.metadata.getAuthors().stream().map(Person::getName).collect(Collectors.toList()), (String)", ");
    }

    @Override
    @Nullable
    public String getHomepage() {
        return this.metadata.getContact().get("homepage").orElse(null);
    }

    @Override
    @Nullable
    public String getIssueTracker() {
        return this.metadata.getContact().get("issues").orElse(null);
    }

    @Override
    @Nullable
    public String getBanner() {
        return this.imageBanner;
    }

    @Override
    @Nullable
    public String getBackground() {
        return this.imageBackground;
    }

    @Override
    public IModData.Update getUpdate() {
        return null;
    }

    @Override
    public boolean hasConfig() {
        return Catalogue.getConfigProviders().containsKey(this.metadata.getId());
    }

    @Override
    public boolean isLogoSmooth() {
        return false;
    }

    @Override
    public void openConfigScreen(class_437 parent) {
        BiFunction<class_437, ModContainer, class_437> configFactory = Catalogue.getConfigProviders().get(this.metadata.getId());
        if (configFactory != null) {
            FabricLoader.getInstance().getModContainer(this.metadata.getId()).ifPresent(container -> {
                class_437 configScreen = (class_437)configFactory.apply(parent, (ModContainer)container);
                if (configScreen != null) {
                    class_310.method_1551().method_1507(configScreen);
                }
            });
        }
    }

    private static IModData.Type analyzeType(ModMetadata metadata) {
        CustomValue lifecycle = metadata.getCustomValue("fabric-api:module-lifecycle");
        if (lifecycle != null) {
            return IModData.Type.LIBRARY;
        }
        String modId = metadata.getId();
        if (modId.startsWith("fabric-") || modId.equals("minecraft") || modId.equals("java") || modId.equals("fabricloader")) {
            return IModData.Type.LIBRARY;
        }
        CustomValue generated = metadata.getCustomValue("fabric-loom:generated");
        if (generated != null && generated.getType() == CustomValue.CvType.BOOLEAN && generated.getAsBoolean()) {
            return IModData.Type.GENERATED;
        }
        return IModData.Type.DEFAULT;
    }
}

