/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.catalogue.platform;

import com.mrcrayfish.catalogue.client.FabricModData;
import com.mrcrayfish.catalogue.client.IModData;
import com.mrcrayfish.catalogue.platform.services.IPlatformHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.minecraft.class_1011;

public class FabricPlatformHelper
implements IPlatformHelper {
    @Override
    public List<IModData> getAllModData() {
        return FabricLoader.getInstance().getAllMods().stream().map(ModContainer::getMetadata).map(FabricModData::new).collect(Collectors.toList());
    }

    @Override
    public File getModDirectory() {
        return FabricLoaderImpl.INSTANCE.getModsDirectory();
    }

    @Override
    public void loadNativeImage(String modId, String resource, Consumer<class_1011> consumer) {
        FabricLoader.getInstance().getModContainer(modId).flatMap(container -> container.findPath(resource)).ifPresent(path -> {
            try (InputStream is = Files.newInputStream(path, new OpenOption[0]);
                 class_1011 icon = class_1011.method_4309((InputStream)is);){
                consumer.accept(icon);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }
}

