/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity;

import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import draylar.identity.ability.AbilityRegistry;
import draylar.identity.api.IdentityTickHandlers;
import draylar.identity.api.PlayerFavorites;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.api.PlayerUnlocks;
import draylar.identity.api.platform.IdentityConfig;
import draylar.identity.network.NetworkHandler;
import draylar.identity.network.ServerNetworking;
import draylar.identity.registry.IdentityCommands;
import draylar.identity.registry.IdentityEntityTags;
import draylar.identity.registry.IdentityEventHandlers;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1480;
import net.minecraft.class_1577;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_167;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Identity {
    public static final Logger LOGGER = LoggerFactory.getLogger(Identity.class);

    public void initialize() {
        IdentityEntityTags.init();
        AbilityRegistry.init();
        IdentityEventHandlers.initialize();
        IdentityCommands.init();
        ServerNetworking.initialize();
        ServerNetworking.registerUseAbilityPacketHandler();
        Identity.registerJoinSyncPacket();
        IdentityTickHandlers.initialize();
    }

    public static void registerJoinSyncPacket() {
        PlayerEvent.PLAYER_JOIN.register(player -> {
            class_2540 packet = new class_2540(Unpooled.buffer());
            packet.writeBoolean(IdentityConfig.getInstance().enableClientSwapMenu());
            packet.writeBoolean(IdentityConfig.getInstance().showPlayerNametag());
            NetworkManager.sendToPlayer((class_3222)player, (class_2960)NetworkHandler.CONFIG_SYNC, (class_2540)packet);
            PlayerUnlocks.sync(player);
            PlayerFavorites.sync(player);
        });
    }

    public static class_2960 id(String name) {
        return new class_2960("identity", name);
    }

    public static boolean hasFlyingPermissions(class_3222 player) {
        class_1309 identity = PlayerIdentity.getIdentity((class_1657)player);
        if (identity != null && IdentityConfig.getInstance().enableFlight() && identity.method_5864().method_20210(IdentityEntityTags.FLYING)) {
            List<String> requiredAdvancements = IdentityConfig.getInstance().advancementsRequiredForFlight();
            if (!requiredAdvancements.isEmpty()) {
                boolean hasPermission = true;
                for (String requiredAdvancement : requiredAdvancements) {
                    class_161 advancement = player.field_13995.method_3851().method_12896(new class_2960(requiredAdvancement));
                    class_167 progress = player.method_14236().method_12882(advancement);
                    if (progress.method_740()) continue;
                    hasPermission = false;
                }
                return hasPermission;
            }
            return true;
        }
        return false;
    }

    public static boolean isAquatic(class_1309 entity) {
        return entity instanceof class_1480 || entity instanceof class_1577;
    }

    public static int getCooldown(class_1299<?> type) {
        String id = class_7923.field_41177.method_10221(type).toString();
        return IdentityConfig.getInstance().getAbilityCooldownMap().getOrDefault(id, 20);
    }
}

