/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.apache.hc.client5.http.impl.io;

import am_libs.org.apache.hc.core5.http.ClassicHttpResponse;
import am_libs.org.apache.hc.core5.http.HttpException;
import am_libs.org.apache.hc.core5.http.HttpResponseFactory;
import am_libs.org.apache.hc.core5.http.config.Http1Config;
import am_libs.org.apache.hc.core5.http.impl.io.DefaultHttpResponseParser;
import am_libs.org.apache.hc.core5.http.message.LineParser;
import am_libs.org.apache.hc.core5.util.CharArrayBuffer;
import am_libs.org.slf4j.Logger;
import am_libs.org.slf4j.LoggerFactory;
import java.io.IOException;

public class LenientHttpResponseParser
extends DefaultHttpResponseParser {
    private static final Logger LOG = LoggerFactory.getLogger(LenientHttpResponseParser.class);

    public LenientHttpResponseParser(LineParser lineParser, HttpResponseFactory<ClassicHttpResponse> responseFactory, Http1Config h1Config) {
        super(h1Config, lineParser, responseFactory);
    }

    public LenientHttpResponseParser(Http1Config h1Config) {
        this(null, null, h1Config);
    }

    @Override
    protected ClassicHttpResponse createMessage(CharArrayBuffer buffer) throws IOException {
        try {
            return super.createMessage(buffer);
        }
        catch (HttpException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Garbage in response: {}", (Object)buffer);
            }
            return null;
        }
    }
}

