/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.cms;

import am_libs.org.bouncycastle.asn1.ASN1OctetString;
import am_libs.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import am_libs.org.bouncycastle.asn1.cms.KEMRecipientInfo;
import am_libs.org.bouncycastle.asn1.cms.RecipientIdentifier;
import am_libs.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import am_libs.org.bouncycastle.cms.CMSException;
import am_libs.org.bouncycastle.cms.CMSSecureReadable;
import am_libs.org.bouncycastle.cms.KEMRecipient;
import am_libs.org.bouncycastle.cms.KEMRecipientId;
import am_libs.org.bouncycastle.cms.Recipient;
import am_libs.org.bouncycastle.cms.RecipientInformation;
import am_libs.org.bouncycastle.cms.RecipientOperator;
import am_libs.org.bouncycastle.util.Arrays;

public class KEMRecipientInformation
extends RecipientInformation {
    private KEMRecipientInfo info;

    KEMRecipientInformation(KEMRecipientInfo kEMRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable) {
        super(kEMRecipientInfo.getKem(), algorithmIdentifier, cMSSecureReadable);
        this.info = kEMRecipientInfo;
        RecipientIdentifier recipientIdentifier = kEMRecipientInfo.getRecipientIdentifier();
        if (recipientIdentifier.isTagged()) {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(recipientIdentifier.getId());
            this.rid = new KEMRecipientId(aSN1OctetString.getOctets());
        } else {
            IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(recipientIdentifier.getId());
            this.rid = new KEMRecipientId(issuerAndSerialNumber.getName(), issuerAndSerialNumber.getSerialNumber().getValue());
        }
    }

    public AlgorithmIdentifier getKdfAlgorithm() {
        return this.info.getKdf();
    }

    public byte[] getUkm() {
        return Arrays.clone(this.info.getUkm());
    }

    public byte[] getEncapsulation() {
        return Arrays.clone(this.info.getKemct().getOctets());
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException {
        return ((KEMRecipient)recipient).getRecipientOperator(new AlgorithmIdentifier(this.keyEncAlg.getAlgorithm(), this.info), this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

