/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.cms;

import am_libs.org.bouncycastle.asn1.DEROctetString;
import am_libs.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import am_libs.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import am_libs.org.bouncycastle.asn1.cms.RecipientIdentifier;
import am_libs.org.bouncycastle.asn1.cms.RecipientInfo;
import am_libs.org.bouncycastle.cms.CMSException;
import am_libs.org.bouncycastle.cms.RecipientInfoGenerator;
import am_libs.org.bouncycastle.operator.AsymmetricKeyWrapper;
import am_libs.org.bouncycastle.operator.GenericKey;
import am_libs.org.bouncycastle.operator.OperatorException;

public abstract class KeyTransRecipientInfoGenerator
implements RecipientInfoGenerator {
    protected final AsymmetricKeyWrapper wrapper;
    private IssuerAndSerialNumber issuerAndSerial;
    private byte[] subjectKeyIdentifier;

    protected KeyTransRecipientInfoGenerator(IssuerAndSerialNumber issuerAndSerialNumber, AsymmetricKeyWrapper asymmetricKeyWrapper) {
        this.issuerAndSerial = issuerAndSerialNumber;
        this.wrapper = asymmetricKeyWrapper;
    }

    protected KeyTransRecipientInfoGenerator(byte[] byArray, AsymmetricKeyWrapper asymmetricKeyWrapper) {
        this.subjectKeyIdentifier = byArray;
        this.wrapper = asymmetricKeyWrapper;
    }

    @Override
    public final RecipientInfo generate(GenericKey genericKey) throws CMSException {
        byte[] byArray;
        try {
            byArray = this.wrapper.generateWrappedKey(genericKey);
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception wrapping content key: " + operatorException.getMessage(), operatorException);
        }
        RecipientIdentifier recipientIdentifier = this.issuerAndSerial != null ? new RecipientIdentifier(this.issuerAndSerial) : new RecipientIdentifier(new DEROctetString(this.subjectKeyIdentifier));
        return new RecipientInfo(new KeyTransRecipientInfo(recipientIdentifier, this.wrapper.getAlgorithmIdentifier(), new DEROctetString(byArray)));
    }
}

