/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.dvcs;

import am_libs.org.bouncycastle.cms.CMSException;
import am_libs.org.bouncycastle.cms.CMSProcessableByteArray;
import am_libs.org.bouncycastle.cms.CMSSignedData;
import am_libs.org.bouncycastle.cms.CMSSignedDataGenerator;
import am_libs.org.bouncycastle.dvcs.DVCSException;
import am_libs.org.bouncycastle.dvcs.DVCSMessage;
import java.io.IOException;

public class SignedDVCSMessageGenerator {
    private final CMSSignedDataGenerator signedDataGen;

    public SignedDVCSMessageGenerator(CMSSignedDataGenerator cMSSignedDataGenerator) {
        this.signedDataGen = cMSSignedDataGenerator;
    }

    public CMSSignedData build(DVCSMessage dVCSMessage) throws DVCSException {
        try {
            byte[] byArray = dVCSMessage.getContent().toASN1Primitive().getEncoded("DER");
            return this.signedDataGen.generate(new CMSProcessableByteArray(dVCSMessage.getContentType(), byArray), true);
        }
        catch (CMSException cMSException) {
            throw new DVCSException("Could not sign DVCS request", cMSException);
        }
        catch (IOException iOException) {
            throw new DVCSException("Could not encode DVCS request", iOException);
        }
    }
}

