/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.config;

import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultChannelConfig;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import network.ycc.raknet.RakNet;
import network.ycc.raknet.config.DefaultCodec;
import network.ycc.raknet.config.DefaultMagic;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class DefaultConfig
extends DefaultChannelConfig
implements RakNet.Config {
    public static final RakNet.Magic DEFAULT_MAGIC = new DefaultMagic(new byte[]{0, -1, -1, 0, -2, -2, -2, -2, -3, -3, -3, -3, 18, 52, 86, 120});
    public static final int DEFAULT_MTU = 1500;
    private static final RakNet.MetricsLogger DEFAULT_METRICS = new RakNet.MetricsLogger(){};
    private static final Random rnd = new Random();
    protected final DescriptiveStatistics rttStats = new DescriptiveStatistics(16);
    private volatile long serverId = rnd.nextLong();
    private volatile long clientId = rnd.nextLong();
    private volatile RakNet.MetricsLogger metrics = DEFAULT_METRICS;
    private volatile int mtu = 1500;
    private volatile long retryDelayNanos = TimeUnit.NANOSECONDS.convert(15L, TimeUnit.MILLISECONDS);
    private volatile int maxPendingFrameSets = 1024;
    private volatile int defaultPendingFrameSets = 32;
    private volatile int maxQueuedBytes = 0x300000;
    private volatile RakNet.Magic magic = DEFAULT_MAGIC;
    private volatile RakNet.Codec codec = DefaultCodec.INSTANCE;
    private volatile int[] protocolVersions = new int[]{9, 10};
    private volatile int maxConnections = 2048;
    private volatile int protocolVersion = 9;
    private volatile boolean ignoreResendGauge = false;
    private volatile boolean NACKEnabled = false;
    private volatile boolean noDelay = false;

    public DefaultConfig(Channel channel) {
        super(channel);
        this.setRTTNanos(TimeUnit.NANOSECONDS.convert(100L, TimeUnit.MILLISECONDS));
    }

    public Map<ChannelOption<?>, Object> getOptions() {
        return this.getOptions(super.getOptions(), new ChannelOption[]{RakNet.SERVER_ID, RakNet.CLIENT_ID, RakNet.METRICS, RakNet.MTU, RakNet.RTT, RakNet.PROTOCOL_VERSION, RakNet.MAGIC, RakNet.RETRY_DELAY_NANOS});
    }

    public <T> T getOption(ChannelOption<T> option) {
        if (option == RakNet.SERVER_ID) {
            return (T)Long.valueOf(this.serverId);
        }
        if (option == RakNet.CLIENT_ID) {
            return (T)Long.valueOf(this.clientId);
        }
        if (option == RakNet.METRICS) {
            return (T)this.metrics;
        }
        if (option == RakNet.MTU) {
            return (T)Integer.valueOf(this.mtu);
        }
        if (option == RakNet.RTT) {
            return (T)Long.valueOf(this.getRTTNanos());
        }
        if (option == RakNet.PROTOCOL_VERSION) {
            return (T)Integer.valueOf(this.protocolVersion);
        }
        if (option == RakNet.MAGIC) {
            return (T)this.magic;
        }
        if (option == RakNet.RETRY_DELAY_NANOS) {
            return (T)Long.valueOf(this.retryDelayNanos);
        }
        if (option == RakNet.MAX_CONNECTIONS) {
            return (T)Integer.valueOf(this.maxConnections);
        }
        return (T)super.getOption(option);
    }

    public <T> boolean setOption(ChannelOption<T> option, T value) {
        if (option == RakNet.SERVER_ID) {
            this.serverId = (Long)value;
        } else if (option == RakNet.CLIENT_ID) {
            this.clientId = (Long)value;
        } else if (option == RakNet.METRICS) {
            this.metrics = (RakNet.MetricsLogger)value;
        } else if (option == RakNet.MTU) {
            this.mtu = (Integer)value;
        } else if (option == RakNet.RTT) {
            this.setRTTNanos((Long)value);
        } else if (option == RakNet.PROTOCOL_VERSION) {
            this.protocolVersion = (Integer)value;
        } else if (option == RakNet.MAGIC) {
            this.magic = (RakNet.Magic)value;
        } else if (option == RakNet.RETRY_DELAY_NANOS) {
            this.retryDelayNanos = (Long)value;
        } else if (option == RakNet.MAX_CONNECTIONS) {
            this.maxConnections = (Integer)value;
        } else {
            return super.setOption(option, value);
        }
        return true;
    }

    @Override
    public boolean containsProtocolVersion(int protocolVersion) {
        for (int version : this.protocolVersions) {
            if (version != protocolVersion) continue;
            return true;
        }
        return false;
    }

    @Override
    public RakNet.MetricsLogger getMetrics() {
        return this.metrics;
    }

    @Override
    public void setMetrics(RakNet.MetricsLogger metrics) {
        this.metrics = metrics;
    }

    @Override
    public long getServerId() {
        return this.serverId;
    }

    @Override
    public void setServerId(long serverId) {
        this.serverId = serverId;
    }

    @Override
    public long getClientId() {
        return this.clientId;
    }

    @Override
    public void setClientId(long clientId) {
        this.clientId = clientId;
    }

    @Override
    public int getMTU() {
        return this.mtu;
    }

    @Override
    public void setMTU(int mtu) {
        this.mtu = mtu;
    }

    @Override
    public long getRetryDelayNanos() {
        return this.retryDelayNanos;
    }

    @Override
    public void setRetryDelayNanos(long retryDelayNanos) {
        this.retryDelayNanos = retryDelayNanos;
    }

    @Override
    public long getRTTNanos() {
        long rtt = (long)this.rttStats.getMean();
        return Math.max(rtt, 1L);
    }

    @Override
    public void setRTTNanos(long rtt) {
        this.rttStats.clear();
        this.rttStats.addValue(rtt);
    }

    @Override
    public long getRTTStdDevNanos() {
        return (long)this.rttStats.getStandardDeviation();
    }

    @Override
    public void updateRTTNanos(long rttSample) {
        this.rttStats.addValue(rttSample);
        this.metrics.measureRTTns(this.getRTTNanos());
        this.metrics.measureRTTnsStdDev(this.getRTTStdDevNanos());
    }

    @Override
    public int getMaxPendingFrameSets() {
        return this.maxPendingFrameSets;
    }

    @Override
    public void setMaxPendingFrameSets(int maxPendingFrameSets) {
        this.maxPendingFrameSets = maxPendingFrameSets;
    }

    @Override
    public int getDefaultPendingFrameSets() {
        return this.defaultPendingFrameSets;
    }

    @Override
    public void setDefaultPendingFrameSets(int defaultPendingFrameSets) {
        this.defaultPendingFrameSets = defaultPendingFrameSets;
    }

    @Override
    public int getMaxQueuedBytes() {
        return this.maxQueuedBytes;
    }

    @Override
    public void setMaxQueuedBytes(int maxQueuedBytes) {
        this.maxQueuedBytes = maxQueuedBytes;
    }

    @Override
    public RakNet.Magic getMagic() {
        return this.magic;
    }

    @Override
    public void setMagic(RakNet.Magic magic) {
        this.magic = magic;
    }

    @Override
    public RakNet.Codec getCodec() {
        return this.codec;
    }

    @Override
    public void setCodec(RakNet.Codec codec) {
        this.codec = codec;
    }

    @Override
    public int[] getProtocolVersions() {
        return this.protocolVersions;
    }

    @Override
    public void setprotocolVersions(int[] protocolVersions) {
        this.protocolVersions = protocolVersions;
    }

    @Override
    public int getMaxConnections() {
        return this.maxConnections;
    }

    @Override
    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    @Override
    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    @Override
    public boolean isIgnoreResendGauge() {
        return this.ignoreResendGauge;
    }

    @Override
    public void setIgnoreResendGauge(boolean ignoreResendGauge) {
        this.ignoreResendGauge = ignoreResendGauge;
    }

    @Override
    public boolean isNACKEnabled() {
        return this.NACKEnabled;
    }

    @Override
    public void setNACKEnabled(boolean NACKEnabled) {
        this.NACKEnabled = NACKEnabled;
    }

    @Override
    public boolean isNoDelayEnabled() {
        return this.noDelay;
    }

    @Override
    public void setNoDelayEnabled(boolean value) {
        this.noDelay = value;
    }
}

