/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.pipeline;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class FlushTickHandler
extends ChannelDuplexHandler {
    public static final String NAME = "rn-flush-tick";
    public static final long TICK_RESOLUTION = TimeUnit.NANOSECONDS.convert(5L, TimeUnit.MILLISECONDS);
    public static final Object FLUSH_CHECK_SIGNAL = new Object();
    protected long tickAccum = 0L;
    protected long lastTickAccum = System.nanoTime();
    protected ScheduledFuture<?> flushTask = null;

    public static void checkFlushTick(Channel channel) {
        channel.pipeline().fireUserEventTriggered(FLUSH_CHECK_SIGNAL);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        assert (this.flushTask == null);
        this.flushTask = ctx.channel().eventLoop().scheduleAtFixedRate(() -> FlushTickHandler.checkFlushTick(ctx.channel()), 0L, 50L, TimeUnit.MILLISECONDS);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.flushTask.cancel(false);
        this.flushTask = null;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.fireChannelReadComplete();
        this.maybeFlush(ctx.channel());
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt == FLUSH_CHECK_SIGNAL) {
            this.maybeFlush(ctx.channel());
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }

    public void flush(ChannelHandlerContext ctx) {
        this.tickAccum = this.tickAccum >= TICK_RESOLUTION ? (this.tickAccum -= TICK_RESOLUTION) : 0L;
        ctx.flush();
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) {
        this.maybeFlush(ctx.channel());
        ctx.fireChannelWritabilityChanged();
    }

    protected void maybeFlush(Channel channel) {
        long curTime = System.nanoTime();
        this.tickAccum += curTime - this.lastTickAccum;
        this.lastTickAccum = curTime;
        if (this.tickAccum >= TICK_RESOLUTION) {
            channel.flush();
            int nFlushes = (int)(this.tickAccum / TICK_RESOLUTION);
            if (nFlushes > 0) {
                this.tickAccum -= (long)nFlushes * TICK_RESOLUTION;
                channel.pipeline().fireUserEventTriggered((Object)new MissedFlushes(nFlushes));
            }
        }
    }

    public class MissedFlushes {
        public final int nFlushes;

        public MissedFlushes(int nFlushes) {
            this.nFlushes = nFlushes;
        }
    }
}

