/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.server.pipeline;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import network.ycc.raknet.RakNet;
import network.ycc.raknet.packet.ClientHandshake;
import network.ycc.raknet.packet.ConnectionFailed;
import network.ycc.raknet.packet.ConnectionReply1;
import network.ycc.raknet.packet.ConnectionReply2;
import network.ycc.raknet.packet.ConnectionRequest;
import network.ycc.raknet.packet.ConnectionRequest1;
import network.ycc.raknet.packet.ConnectionRequest2;
import network.ycc.raknet.packet.InvalidVersion;
import network.ycc.raknet.packet.Packet;
import network.ycc.raknet.packet.ServerHandshake;
import network.ycc.raknet.pipeline.AbstractConnectionInitializer;

public class ConnectionInitializer
extends AbstractConnectionInitializer {
    protected boolean clientIdSet = false;
    protected boolean mtuFixed = false;
    protected boolean seenFirst = false;

    public ConnectionInitializer(ChannelPromise connectPromise) {
        super(connectPromise);
    }

    public static void setFixedMTU(Channel channel, int mtu) {
        channel.eventLoop().execute(() -> {
            ((ConnectionInitializer)channel.pipeline().get(ConnectionInitializer.class)).mtuFixed = true;
            RakNet.config(channel).setMTU(mtu);
        });
    }

    public void channelRead0(ChannelHandlerContext ctx, Packet msg) {
        RakNet.Config config = RakNet.config(ctx);
        if (msg instanceof Packet.ClientIdConnection) {
            this.processClientId(ctx, ((Packet.ClientIdConnection)msg).getClientId());
        } else if (msg instanceof ConnectionFailed) {
            throw new IllegalStateException("Connection failed");
        }
        switch (this.state) {
            case CR1: {
                if (msg instanceof ConnectionRequest1) {
                    ConnectionRequest1 cr1 = (ConnectionRequest1)msg;
                    cr1.getMagic().verify(config.getMagic());
                    if (!this.mtuFixed) {
                        config.setMTU(cr1.getMtu());
                    }
                    this.seenFirst = true;
                    if (!config.containsProtocolVersion(cr1.getProtocolVersion())) {
                        InvalidVersion packet = new InvalidVersion(config.getMagic(), config.getServerId());
                        ctx.writeAndFlush((Object)packet).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                        return;
                    }
                    config.setProtocolVersion(cr1.getProtocolVersion());
                    break;
                }
                if (!(msg instanceof ConnectionRequest2)) break;
                ConnectionRequest2 cr2 = (ConnectionRequest2)msg;
                cr2.getMagic().verify(config.getMagic());
                if (!this.mtuFixed) {
                    config.setMTU(cr2.getMtu());
                }
                this.state = AbstractConnectionInitializer.State.CR2;
                break;
            }
            case CR2: {
                if (!(msg instanceof ConnectionRequest)) break;
                ConnectionRequest cr = (ConnectionRequest)msg;
                ServerHandshake packet = new ServerHandshake((InetSocketAddress)ctx.channel().remoteAddress(), cr.getTimestamp());
                ctx.writeAndFlush((Object)packet).addListener((GenericFutureListener)RakNet.INTERNAL_WRITE_LISTENER);
                this.state = AbstractConnectionInitializer.State.CR3;
                this.startPing(ctx);
                break;
            }
            case CR3: {
                if (!(msg instanceof ClientHandshake)) break;
                this.finish(ctx);
                return;
            }
            default: {
                throw new IllegalStateException("Unknown state " + (Object)((Object)this.state));
            }
        }
        this.sendRequest(ctx);
    }

    @Override
    public void sendRequest(ChannelHandlerContext ctx) {
        assert (ctx.channel().eventLoop().inEventLoop());
        RakNet.Config config = RakNet.config(ctx);
        switch (this.state) {
            case CR1: {
                if (!this.seenFirst) break;
                ConnectionReply1 packet = new ConnectionReply1(config.getMagic(), config.getMTU(), config.getServerId());
                ctx.writeAndFlush((Object)packet).addListener((GenericFutureListener)RakNet.INTERNAL_WRITE_LISTENER);
                break;
            }
            case CR2: {
                ConnectionReply2 packet = new ConnectionReply2(config.getMagic(), config.getMTU(), config.getServerId(), (InetSocketAddress)ctx.channel().remoteAddress());
                ctx.writeAndFlush((Object)packet).addListener((GenericFutureListener)RakNet.INTERNAL_WRITE_LISTENER);
                break;
            }
            case CR3: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state " + (Object)((Object)this.state));
            }
        }
    }

    @Override
    protected void removeHandler(ChannelHandlerContext ctx) {
        ctx.channel().pipeline().replace("rn-init-connect", "rn-init-connect", (ChannelHandler)new RestartConnectionHandler());
    }

    protected void processClientId(ChannelHandlerContext ctx, long clientId) {
        RakNet.Config config = RakNet.config(ctx);
        if (!this.clientIdSet) {
            config.setClientId(clientId);
            this.clientIdSet = true;
        } else if (config.getClientId() != clientId) {
            throw new IllegalStateException("Connection sequence restarted");
        }
    }

    protected static class RestartConnectionHandler
    extends ChannelInboundHandlerAdapter {
        protected RestartConnectionHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (msg instanceof Packet.ClientIdConnection) {
                Packet.ClientIdConnection clientIdConnectionPacket = (Packet.ClientIdConnection)msg;
                RakNet.Config config = RakNet.config(ctx);
                if (clientIdConnectionPacket.getClientId() == config.getClientId()) {
                    System.err.println(String.format("Warning: Not restarting RakNet connection for client %s (Possibly caused by high latency)", ctx.channel().remoteAddress()));
                } else {
                    ctx.writeAndFlush((Object)new ConnectionFailed(config.getMagic())).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    ReferenceCountUtil.safeRelease((Object)msg);
                }
            } else if (msg instanceof ConnectionRequest1) {
                RakNet.Config config = RakNet.config(ctx);
                ctx.writeAndFlush((Object)new ConnectionFailed(config.getMagic())).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                ReferenceCountUtil.safeRelease((Object)msg);
            } else if (msg instanceof ConnectionFailed) {
                ReferenceCountUtil.safeRelease((Object)msg);
                ctx.close();
            } else {
                ctx.fireChannelRead(msg);
            }
        }
    }
}

