/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.server.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.ReferenceCountUtil;
import java.net.InetSocketAddress;
import network.ycc.raknet.RakNet;
import network.ycc.raknet.packet.FramedPacket;
import network.ycc.raknet.packet.Packet;

public abstract class UdpPacketHandler<T extends Packet>
extends SimpleChannelInboundHandler<DatagramPacket> {
    private final Class<T> type;
    private int packetId;

    public UdpPacketHandler(Class<T> type) {
        if (FramedPacket.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Framed packet types cannot be directly handled by UdpPacketHandler");
        }
        this.type = type;
    }

    protected abstract void handle(ChannelHandlerContext var1, InetSocketAddress var2, InetSocketAddress var3, T var4);

    public void handlerAdded(ChannelHandlerContext ctx) {
        RakNet.Config config = RakNet.config(ctx);
        this.packetId = config.getCodec().packetIdFor(this.type);
        if (this.packetId == -1) {
            throw new IllegalArgumentException("Unknown packet ID for class " + this.type);
        }
    }

    public boolean acceptInboundMessage(Object msg) {
        if (msg instanceof DatagramPacket) {
            ByteBuf content = (ByteBuf)((DatagramPacket)msg).content();
            return content.getUnsignedByte(content.readerIndex()) == this.packetId;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket msg) {
        RakNet.Config config = RakNet.config(ctx);
        Packet packet = config.getCodec().decode((ByteBuf)msg.content());
        try {
            this.handle(ctx, (InetSocketAddress)msg.sender(), (InetSocketAddress)msg.recipient(), packet);
        }
        finally {
            ReferenceCountUtil.release((Object)packet);
        }
    }

    public Class<T> getType() {
        return this.type;
    }

    public int getPacketId() {
        return this.packetId;
    }

    public void setPacketId(int packetId) {
        this.packetId = packetId;
    }
}

