/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.customprofessions.config;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import uk.co.dotcode.customprofessions.config.CustomProfession;

public class ConfigHandler {
    public static File folder;
    public ArrayList<CustomProfession> configProfessions = new ArrayList();

    public void load() {
        File[] fileArray;
        if (!folder.exists()) {
            folder.mkdirs();
            LogManager.getLogger((String)"spacecatcustomprofessions").log(Level.INFO, "No configs found, creating directory");
        }
        if ((fileArray = folder.listFiles()) != null && fileArray.length > 0) {
            Gson gson = new Gson();
            for (File f : fileArray) {
                if (f.isDirectory() || !this.isJsonFile(f)) continue;
                this.loadFile(gson, f);
            }
        }
    }

    private void loadFile(Gson gson, File file) {
        LogManager.getLogger((String)"spacecatcustomprofessions").log(Level.INFO, "Loading custom professions");
        try (FileReader reader = new FileReader(file);){
            CustomProfession cp = (CustomProfession)gson.fromJson((Reader)reader, CustomProfession.class);
            if (cp.blockPOIkey != null) {
                this.configProfessions.add(cp);
                LogManager.getLogger((String)"spacecatcustomprofessions").log(Level.INFO, "Added custom profession: " + cp.professionName);
            } else {
                LogManager.getLogger((String)"spacecatcustomprofessions").log(Level.WARN, "Failed to add custom profession: " + cp.professionName + ", the blockPOIkey is not correctly defined! (Check your spelling and capital letters)");
            }
        }
        catch (FileNotFoundException e) {
            LogManager.getLogger((String)"spacecatcustomprofessions").log(Level.ERROR, "Failed to load custom profession (file not found): " + file.getPath());
            e.printStackTrace();
        }
        catch (IOException e) {
            LogManager.getLogger((String)"spacecatcustomprofessions").log(Level.ERROR, "Failed to load custom profession (IOException): " + file.getPath());
            e.printStackTrace();
        }
    }

    private boolean isJsonFile(File f) {
        String extension = f.getPath().substring(f.getPath().lastIndexOf("."));
        return extension.equalsIgnoreCase(".json");
    }
}

