/*
 * Decompiled with CFR 0.152.
 */
package supercoder79.chunkpregen;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.text.DecimalFormat;
import java.util.concurrent.atomic.AtomicLong;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import supercoder79.chunkpregen.PregenBar;
import supercoder79.chunkpregen.PregenerationTask;

public final class Commands {
    private static final DecimalFormat PERCENT_FORMAT = new DecimalFormat("#.00");
    private static PregenerationTask activeTask;
    private static PregenBar pregenBar;

    public static void init() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            LiteralArgumentBuilder lab = (LiteralArgumentBuilder)class_2170.method_9247((String)"pregen").requires(executor -> {
                if (executor.method_9211().method_3724()) {
                    return true;
                }
                return executor.method_9259(2);
            });
            AtomicLong atotal = new AtomicLong();
            AtomicLong atime = new AtomicLong();
            lab.then(class_2170.method_9247((String)"start").then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(cmd -> {
                class_2168 source = (class_2168)cmd.getSource();
                if (activeTask != null) {
                    source.method_9226(() -> class_2561.method_43470((String)"Pregen already running. Please execute '/pregen stop' to start another pregeneration."), true);
                    return 1;
                }
                int radius = IntegerArgumentType.getInteger((CommandContext)cmd, (String)"radius");
                class_1923 origin = source.method_9228() == null ? new class_1923(0, 0) : new class_1923(class_2338.method_49638((class_2374)source.method_44023().method_19538()));
                activeTask = new PregenerationTask(source.method_9225(), origin.field_9181, origin.field_9180, radius);
                int diameter = radius * 2 + 1;
                pregenBar = new PregenBar();
                if (source.method_9228() instanceof class_3222) {
                    pregenBar.addPlayer(source.method_44023());
                }
                source.method_9226(() -> class_2561.method_43470((String)("Pregenerating " + activeTask.getTotalCount() + " chunks, in an area of " + diameter + "x" + diameter + " chunks (" + diameter * 16 + "x" + diameter * 16 + " blocks).")), true);
                activeTask.run(Commands.createPregenListener(source));
                return 1;
            })));
            lab.then(class_2170.method_9247((String)"stop").executes(cmd -> {
                if (activeTask != null) {
                    activeTask.stop();
                    int count = activeTask.getOkCount() + activeTask.getErrorCount();
                    int total = activeTask.getTotalCount();
                    double percent = (double)count / (double)total * 100.0;
                    String message = "Pregen stopped! " + count + " out of " + total + " chunks generated. (" + percent + "%)";
                    ((class_2168)cmd.getSource()).method_9226(() -> class_2561.method_43470((String)message), true);
                    pregenBar.close();
                    pregenBar = null;
                    activeTask = null;
                }
                return 1;
            }));
            lab.then(class_2170.method_9247((String)"status").executes(cmd -> {
                if (activeTask != null) {
                    int count = activeTask.getOkCount() + activeTask.getErrorCount();
                    int total = activeTask.getTotalCount();
                    double percent = (double)count / (double)total * 100.0;
                    String message = "Pregen status: " + count + " out of " + total + " chunks generated. (" + percent + "%)";
                    ((class_2168)cmd.getSource()).method_9226(() -> class_2561.method_43470((String)message), true);
                } else {
                    ((class_2168)cmd.getSource()).method_9226(() -> class_2561.method_43470((String)"No pregeneration currently running. Run /pregen start <radius> to start."), false);
                }
                return 1;
            }));
            lab.then(class_2170.method_9247((String)"help").executes(cmd -> {
                class_2168 source = (class_2168)cmd.getSource();
                source.method_9226(() -> class_2561.method_43470((String)"\u00a72/pregen start <radius> - Pregenerate a square centered on the player that is <radius> * 2 chunks long and wide."), false);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a72/pregen stop - Stop pregeneration and displays the amount completed."), false);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a72/pregen status - Display the amount of chunks pregenerated."), false);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a72/pregen help - Display this message."), false);
                source.method_9226(() -> class_2561.method_43470((String)"General tips: When running from a player, the center position will be the chunk you're standing on."), false);
                source.method_9226(() -> class_2561.method_43470((String)"If running from a server console, the center position will be 0, 0. You can run pregen for different dimensions using /execute in <dimension> pregen start <radius>"), false);
                return 1;
            }));
            dispatcher.register(lab);
        });
    }

    private static PregenerationTask.Listener createPregenListener(final class_2168 source) {
        return new PregenerationTask.Listener(){

            @Override
            public void update(int ok, int error, int total) {
                pregenBar.update(ok, error, total);
            }

            @Override
            public void complete(int error) {
                source.method_9226(() -> class_2561.method_43470((String)"Pregeneration Done!"), true);
                if (error > 0) {
                    source.method_9226(() -> class_2561.method_43470((String)("Pregeneration experienced " + error + " errors! Check the log for more information")), true);
                }
                pregenBar.close();
                pregenBar = null;
                activeTask = null;
            }
        };
    }
}

