/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigapiport.impl.config;

import fuzs.forgeconfigapiport.api.config.v2.ForgeConfigPaths;
import fuzs.forgeconfigapiport.impl.ForgeConfigAPIPort;
import fuzs.forgeconfigapiport.impl.config.ForgeConfigApiPortConfig;
import fuzs.forgeconfigapiport.mixin.accessor.LevelResourceAccessor;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public final class ForgeConfigPathsImpl
implements ForgeConfigPaths {
    private static final class_5218 SERVER_CONFIG_LEVEL_RESOURCE = LevelResourceAccessor.forgeconfigapiport$create("serverconfig");

    private static Path getOrCreateDirectory(Path dirPath, String dirLabel) {
        if (!Files.isDirectory(dirPath.getParent(), new LinkOption[0])) {
            ForgeConfigPathsImpl.getOrCreateDirectory(dirPath.getParent(), "parent of " + dirLabel);
        }
        if (!Files.isDirectory(dirPath, new LinkOption[0])) {
            ForgeConfigAPIPort.LOGGER.debug("Making {} directory : {}", (Object)dirLabel, (Object)dirPath);
            try {
                Files.createDirectory(dirPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                if (e instanceof FileAlreadyExistsException) {
                    ForgeConfigAPIPort.LOGGER.error("Failed to create {} directory - there is a file in the way", (Object)dirLabel);
                } else {
                    ForgeConfigAPIPort.LOGGER.error("Problem with creating {} directory (Permissions?)", (Object)dirLabel, (Object)e);
                }
                throw new RuntimeException("Problem creating directory", e);
            }
            ForgeConfigAPIPort.LOGGER.debug("Created {} directory : {}", (Object)dirLabel, (Object)dirPath);
        } else {
            ForgeConfigAPIPort.LOGGER.debug("Found existing {} directory : {}", (Object)dirLabel, (Object)dirPath);
        }
        return dirPath;
    }

    @Override
    public Path getClientConfigDirectory() {
        return FabricLoader.getInstance().getConfigDir();
    }

    @Override
    public Path getCommonConfigDirectory() {
        return FabricLoader.getInstance().getConfigDir();
    }

    @Override
    public Path getServerConfigDirectory(MinecraftServer server) {
        if (this.forceGlobalServerConfigs()) {
            return FabricLoader.getInstance().getConfigDir();
        }
        Path serverConfig = server.method_27050(SERVER_CONFIG_LEVEL_RESOURCE);
        ForgeConfigPathsImpl.getOrCreateDirectory(serverConfig, "server config directory");
        return serverConfig;
    }

    @Override
    public boolean forceGlobalServerConfigs() {
        return (Boolean)ForgeConfigApiPortConfig.INSTANCE.getValue("forceGlobalServerConfigs");
    }

    @Override
    public Path getDefaultConfigsDirectory() {
        Path defaultConfigs = FabricLoader.getInstance().getGameDir().resolve((String)ForgeConfigApiPortConfig.INSTANCE.getValue("defaultConfigsPath"));
        ForgeConfigPathsImpl.getOrCreateDirectory(defaultConfigs, "default configs directory");
        return defaultConfigs;
    }
}

