/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.mobbattle.client.gui;

import io.github.flemmli97.mobbattle.MobBattle;
import io.github.flemmli97.mobbattle.client.gui.SuggestionEditBox;
import io.github.flemmli97.mobbattle.items.ItemExtendedSpawnEgg;
import io.github.flemmli97.mobbattle.network.C2SSpawnEgg;
import io.github.flemmli97.mobbattle.platform.CrossPlatformStuff;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_5348;

public class SpawnEggScreen
extends class_437 {
    private final class_1657 player;
    protected final class_1308 entity;
    private final class_1268 hand;
    private int leftPos;
    private int topPos;
    private final int sizeX = 240;
    private final int sizeY = 200;
    private String team;
    private int amount;
    private int spacing;
    private class_342 teamBox;

    public SpawnEggScreen(class_1268 hand) {
        super((class_2561)class_2561.method_43473());
        class_1308 mob;
        this.hand = hand;
        this.player = class_310.method_1551().field_1724;
        class_1799 stack = this.player.method_5998(this.hand);
        class_1297 entity = ItemExtendedSpawnEgg.getEntity(this.player.method_37908(), stack);
        this.entity = entity instanceof class_1308 ? (mob = (class_1308)entity) : null;
        ItemExtendedSpawnEgg.SpawnOptions options = ItemExtendedSpawnEgg.getOptions(stack);
        this.team = options.team() != null ? options.team() : "";
        this.amount = options.amount();
        this.spacing = options.spacing();
    }

    protected void method_25426() {
        super.method_25426();
        if (this.entity == null) {
            this.field_22787.method_1507(null);
            return;
        }
        this.leftPos = this.field_22789 / 2 - this.sizeX / 2;
        this.topPos = this.field_22790 / 2 - this.sizeY / 2;
        this.buttons();
    }

    public void method_25393() {
        super.method_25393();
        ++this.entity.field_6012;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        int xPadding;
        guiGraphics.method_25296(this.leftPos, this.topPos, this.leftPos + this.sizeX, this.topPos + this.sizeY, -1072689136, -1072689136);
        int yOff = xPadding = 16;
        int width = this.field_22793.method_27525((class_5348)this.entity.method_5864().method_5897());
        class_2561 class_25612 = this.entity.method_5864().method_5897();
        float f = this.leftPos;
        Objects.requireNonNull(this);
        guiGraphics.method_27535(this.field_22793, class_25612, (int)(f + 240.0f * 0.5f - (float)width * 0.5f), this.topPos + yOff, class_124.field_1065.method_532().intValue());
        guiGraphics.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"mobbattle.gui.team"), this.leftPos + xPadding, this.topPos + (yOff += 16), 0xFFFFFF);
        guiGraphics.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"mobbattle.gui.amount"), this.leftPos + xPadding, this.topPos + (yOff += 44), 0xFFFFFF);
        guiGraphics.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"mobbattle.gui.spacing"), this.leftPos + xPadding, this.topPos + (yOff += 36), 0xFFFFFF);
        SpawnEggScreen.renderEntityMouseNoClip(guiGraphics, this.leftPos + this.sizeX - xPadding - 90, this.topPos + xPadding + 16, 30, 3.0f, 3.0f, mouseX, mouseY, (class_1309)this.entity);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    public static void renderEntityMouseNoClip(class_332 guiGraphics, int x, int y, int scale, float maxWidth, float maxHeight, float mouseX, float mouseY, class_1309 entity) {
        float sizeX = maxWidth * (float)scale;
        float sizeY = maxHeight * (float)scale;
        float scaleMult = 1.0f;
        if (entity.method_17681() > maxWidth) {
            scaleMult = maxWidth / entity.method_17681();
        }
        if (entity.method_17682() > maxHeight) {
            scaleMult = Math.min(scaleMult, maxHeight / entity.method_17682());
        }
        float xPos = ((float)(x + x) + sizeX) / 2.0f;
        float yPos = ((float)(y + y) + sizeY) / 2.0f + entity.method_17682() * 0.5f * scaleMult * (float)scale;
        float eyePos = yPos - entity.method_5751() * scaleMult * (float)scale;
        class_490.method_2486((class_332)guiGraphics, (int)((int)xPos), (int)((int)yPos), (int)((int)((float)scale * scaleMult)), (float)(xPos - mouseX), (float)(eyePos - mouseY), (class_1309)entity);
    }

    protected void buttons() {
        int padding = 16;
        int yOff = padding + 12 + 16;
        this.teamBox = new SuggestionEditBox(this.field_22793, this.leftPos + padding, this.topPos + yOff, 100, 14, (class_2561)class_2561.method_43473(), 5, false, SuggestionEditBox.ofString(this.player.method_37908().method_8428().method_1196()));
        this.teamBox.method_1863(s -> {
            this.team = s;
        });
        this.teamBox.method_1880(35);
        this.teamBox.method_1888(true);
        this.teamBox.method_1852(this.team);
        this.method_37063((class_364)this.teamBox);
        class_342 amountBox = new class_342(this.field_22793, this.leftPos + padding, this.topPos + (yOff += 44), 27, 10, (class_2561)class_2561.method_43473()){

            public boolean method_25400(char typedChar, int keyCode) {
                if ((Character.isDigit(typedChar) || SpawnEggScreen.this.isHelperKey(keyCode)) && super.method_25400(typedChar, keyCode) && !this.method_1882().isEmpty()) {
                    try {
                        int amount = Integer.parseInt(this.method_1882());
                        if (amount > 100) {
                            amount = 100;
                            this.method_1852("" + amount);
                        }
                        SpawnEggScreen.this.amount = amount;
                    }
                    catch (NumberFormatException e) {
                        MobBattle.LOGGER.error(this.method_1882() + " not a number");
                    }
                    return true;
                }
                return false;
            }
        };
        amountBox.method_1880(3);
        amountBox.method_1888(true);
        amountBox.method_1852("" + this.amount);
        this.method_37063((class_364)amountBox);
        class_342 spacingBox = new class_342(this.field_22793, this.leftPos + padding, this.topPos + (yOff += 36), 27, 10, (class_2561)class_2561.method_43473()){

            public boolean method_25400(char typedChar, int keyCode) {
                if ((Character.isDigit(typedChar) || SpawnEggScreen.this.isHelperKey(keyCode)) && super.method_25400(typedChar, keyCode) && !this.method_1882().isEmpty()) {
                    try {
                        SpawnEggScreen.this.spacing = Integer.parseInt(this.method_1882());
                    }
                    catch (NumberFormatException e) {
                        MobBattle.LOGGER.error(this.method_1882() + " not a number");
                    }
                    return true;
                }
                return false;
            }
        };
        spacingBox.method_1880(2);
        spacingBox.method_1888(true);
        spacingBox.method_1852("" + this.spacing);
        this.method_37063((class_364)spacingBox);
        yOff = this.sizeY - padding - 20;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"mobbattle.gui.save"), b -> {
            CrossPlatformStuff.INSTANCE.sendToServer(new C2SSpawnEgg(this.hand, this.team, this.amount, this.spacing));
            this.field_22787.method_1507(null);
        }).method_46434(this.leftPos + this.sizeX / 2 - 50, this.topPos + yOff, 100, 20).method_46431());
    }

    private boolean isHelperKey(int keyCode) {
        return keyCode == 14 || keyCode == 199 || keyCode == 203 || keyCode == 205 || keyCode == 207 || keyCode == 211;
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.teamBox.method_20315() && this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean click = super.method_25402(mouseX, mouseY, button);
        if (!click) {
            this.method_25395(null);
        }
        return click;
    }
}

