/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.visualoverhaul;

import com.mojang.blaze3d.systems.RenderSystem;
import eu.midnightdust.visualoverhaul.config.VOConfig;
import eu.midnightdust.visualoverhaul.mixin.TextureManagerAccessor;
import eu.midnightdust.visualoverhaul.util.ModIconUtil;
import java.io.InputStream;
import java.util.Properties;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1049;
import net.minecraft.class_1060;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5348;
import net.minecraft.class_7417;
import org.apache.logging.log4j.LogManager;

public class IconicButtons {
    class_310 client = class_310.method_1551();
    private String buttonId;
    private class_2561 prevText;
    private class_2960 iconId;

    public IconicButtons(class_339 widget) {
        this.init(widget);
    }

    public void init(class_339 widget) {
        this.prevText = widget.method_25369();
        class_7417 class_74172 = widget.method_25369().method_10851();
        if (class_74172 instanceof class_2588) {
            class_2588 translatableTextContent = (class_2588)class_74172;
            v0 = translatableTextContent.method_11022().toLowerCase();
        } else {
            v0 = this.buttonId = "";
        }
        if (VOConfig.buttonIcons && !this.buttonId.equals("")) {
            if (VOConfig.debug) {
                System.out.println(this.buttonId);
            }
            this.iconId = class_2960.method_12829((String)("iconic:textures/gui/icons/" + this.buttonId.toLowerCase() + ".png"));
            if (this.buttonId.endsWith(".midnightconfig.title")) {
                this.iconId = new class_2960("modid", this.buttonId.replace(".midnightconfig.title", "") + "_icon");
                class_1043 icon = new ModIconUtil(this.buttonId.replace(".midnightconfig.title", "")).createModIcon();
                if (icon != null) {
                    this.client.method_1531().method_4616(this.iconId, (class_1044)icon);
                } else {
                    this.iconId = null;
                }
            }
            if (this.iconId == null) {
                return;
            }
            class_1060 textureManager = this.client.method_1531();
            class_1044 abstractTexture = textureManager.method_34590(this.iconId, null);
            if (abstractTexture == null) {
                abstractTexture = new class_1049(this.iconId);
                try {
                    abstractTexture.method_4625(((TextureManagerAccessor)textureManager).getResourceContainer());
                }
                catch (Exception e) {
                    this.iconId = null;
                    return;
                }
                textureManager.method_4616(this.iconId, abstractTexture);
            }
            if (abstractTexture == class_1047.method_4540()) {
                this.iconId = null;
            }
        }
    }

    public void renderIcons(class_332 context, class_339 widget, float alpha) {
        if (widget.method_25369() == null) {
            return;
        }
        if (this.prevText != widget.method_25369()) {
            this.init(widget);
        }
        if (VOConfig.buttonIcons && !this.buttonId.equals("") && this.iconId != null) {
            int scaledWidth = this.client.method_22683().method_4486();
            boolean limitedSpace = (float)this.client.field_1772.method_27525((class_5348)widget.method_25369()) > (float)widget.method_25368() * 0.75f;
            boolean showLeftWhenBoth = VOConfig.buttonIconPosition.equals((Object)VOConfig.IconPosition.BOTH) && !limitedSpace || VOConfig.buttonIconPosition.equals((Object)VOConfig.IconPosition.BOTH) && widget.method_46426() < scaledWidth / 2;
            boolean showRightWhenBoth = VOConfig.buttonIconPosition.equals((Object)VOConfig.IconPosition.BOTH) && !limitedSpace || VOConfig.buttonIconPosition.equals((Object)VOConfig.IconPosition.BOTH) && widget.method_46426() > scaledWidth / 2;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            if (!widget.field_22763) {
                RenderSystem.setShaderColor((float)0.3f, (float)0.3f, (float)0.3f, (float)alpha);
            }
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            int inset = 2;
            if (VOConfig.zoomIconOnHover && widget.method_25367()) {
                inset = 1;
            }
            int size = 20 - inset * 2;
            if (VOConfig.buttonIconPosition.equals((Object)VOConfig.IconPosition.LEFT) || showLeftWhenBoth || VOConfig.buttonIconPosition.equals((Object)VOConfig.IconPosition.LOCATION) && widget.method_46426() < scaledWidth / 2) {
                context.method_25290(this.iconId, widget.method_46426() + inset, widget.method_46427() + inset, 0.0f, 0.0f, size, size, size, size);
            }
            if (VOConfig.buttonIconPosition.equals((Object)VOConfig.IconPosition.RIGHT) || showRightWhenBoth || VOConfig.buttonIconPosition.equals((Object)VOConfig.IconPosition.LOCATION) && widget.method_46426() + widget.method_25368() > scaledWidth / 2) {
                context.method_25290(this.iconId, widget.method_46426() + widget.method_25368() - 20 + inset, widget.method_46427() + inset, 0.0f, 0.0f, size, size, size, size);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void reload(class_3300 manager) {
        manager.method_14488("textures", path -> path.method_12832().contains(".properties")).forEach((id, resource) -> {
            if (manager.method_14486(id).isEmpty()) {
                return;
            }
            try (InputStream stream = ((class_3298)manager.method_14486(id).get()).method_14482();){
                class_2960 iconId = new class_2960(id.method_12836(), id.method_12832().replace(".properties", ".png"));
                if (manager.method_14486(iconId).isPresent()) {
                    return;
                }
                Properties properties = new Properties();
                properties.load(stream);
                while (properties.get("properties") != null) {
                    class_2960 propertiesId = new class_2960(properties.getProperty("properties"));
                    String textureId = propertiesId.toString().replace(".properties", ".png");
                    properties.clear();
                    if (manager.method_14486(class_2960.method_12829((String)textureId)).isPresent()) {
                        properties.put("texture", textureId);
                        continue;
                    }
                    if (manager.method_14486(propertiesId).isPresent()) {
                        properties.load(((class_3298)manager.method_14486(propertiesId).get()).method_14482());
                        continue;
                    }
                    return;
                }
                if (properties.get("texture") != null) {
                    class_2960 textureId = new class_2960(properties.getProperty("texture"));
                    class_1060 textureManager = class_310.method_1551().method_1531();
                    class_1044 abstractTexture = textureManager.method_34590(iconId, null);
                    if (abstractTexture == null) {
                        abstractTexture = new class_1049(textureId);
                        textureManager.method_4616(iconId, abstractTexture);
                    }
                }
            }
            catch (Exception e) {
                LogManager.getLogger((String)"Iconic").error("Error occurred while loading texture.properties " + id.toString(), (Throwable)e);
            }
        });
    }
}

