/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.visualoverhaul.util;

import dev.architectury.injectables.annotations.ExpectPlatform;
import eu.midnightdust.visualoverhaul.config.VOConfig;
import eu.midnightdust.visualoverhaul.util.fabric.ModIconUtilImpl;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import org.apache.commons.lang3.Validate;
import org.spongepowered.asm.mixin.Unique;

public class ModIconUtil {
    private static final Map<Path, class_1043> modIconCache = new HashMap<Path, class_1043>();
    private final String modid;

    public ModIconUtil(String modid) {
        this.modid = modid;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getPath(String modid) {
        return ModIconUtilImpl.getPath(modid);
    }

    @Unique
    public class_1043 createModIcon() {
        class_1043 class_10432;
        block12: {
            class_1043 cachedIcon;
            Path path = ModIconUtil.getPath(this.modid);
            if (VOConfig.debug) {
                System.out.println(path);
            }
            if ((cachedIcon = ModIconUtil.getCachedModIcon(path)) != null) {
                return cachedIcon;
            }
            cachedIcon = ModIconUtil.getCachedModIcon(path);
            if (cachedIcon != null) {
                return cachedIcon;
            }
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            try {
                class_1011 image = class_1011.method_4309((InputStream)Objects.requireNonNull(inputStream));
                Validate.validState((image.method_4323() == image.method_4307() ? 1 : 0) != 0, (String)"Must be square icon", (Object[])new Object[0]);
                class_1043 tex = new class_1043(image);
                ModIconUtil.cacheModIcon(path, tex);
                class_10432 = tex;
                if (inputStream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    if (VOConfig.debug) {
                        System.out.println(t.getMessage());
                    }
                    return null;
                }
            }
            inputStream.close();
        }
        return class_10432;
    }

    static class_1043 getCachedModIcon(Path path) {
        return modIconCache.get(path);
    }

    static void cacheModIcon(Path path, class_1043 tex) {
        modIconCache.put(path, tex);
    }
}

