/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.entities.living.immortal;

import com.github.teamfusion.rottencreatures.client.registries.RCSoundEvents;
import com.github.teamfusion.rottencreatures.common.level.entities.living.SpellcasterZombie;
import com.github.teamfusion.rottencreatures.common.level.entities.living.zap.Zap;
import com.github.teamfusion.rottencreatures.common.registries.RCBlocks;
import com.github.teamfusion.rottencreatures.common.registries.RCMobEffects;
import com.github.teamfusion.rottencreatures.core.data.tags.RCEntityTypeTags;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1538;
import net.minecraft.class_1642;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;

public class Immortal
extends SpellcasterZombie {
    public static final class_2940<Boolean> DASH = class_2945.method_12791(Immortal.class, (class_2941)class_2943.field_13323);

    public Immortal(class_1299<? extends SpellcasterZombie> type, class_1937 level) {
        super(type, level);
        this.field_6194 = 30;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1642.method_26940().method_26868(class_5134.field_23727, 0.0).method_26868(class_5134.field_23716, 25.0).method_26868(class_5134.field_23719, 0.23).method_26868(class_5134.field_23717, 50.0).method_26868(class_5134.field_23721, 10.0).method_26868(class_5134.field_23724, 2.0);
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(DASH, (Object)false);
    }

    public boolean isDashing() {
        return (Boolean)this.method_5841().method_12789(DASH);
    }

    public void setDashing(boolean dashing) {
        this.method_5841().method_12778(DASH, (Object)dashing);
    }

    public boolean method_6109() {
        return false;
    }

    public void method_7217(boolean baby) {
    }

    protected void method_7208() {
        super.method_7208();
        this.field_6201.method_6277(1, (class_1352)new SpellcasterZombie.CastingSpellGoal());
        this.field_6201.method_6277(5, (class_1352)new SummonLightningGoal());
        this.field_6201.method_6277(7, (class_1352)new DashingGoal(this));
        this.field_6185.method_6277(1, (class_1352)new class_1400<class_1642>((class_1308)this, class_1642.class, true){

            public boolean method_6264() {
                return super.method_6264() && this.field_6644 != null && !this.field_6644.method_5864().method_20210(RCEntityTypeTags.IMMORTAL_IGNORE);
            }
        });
    }

    @Override
    protected void method_5958() {
        super.method_5958();
        if ((this.field_6012 + this.method_5628()) % 1200 == 0) {
            boolean shouldApplyEffect;
            class_1291 effect = class_1294.field_5910;
            List zaps = this.method_37908().method_18467(Zap.class, this.method_5829().method_1009(16.0, 4.0, 16.0));
            int size = Math.max(0, zaps.size() - 1);
            boolean bl = shouldApplyEffect = !this.method_6059(effect) || this.method_6112(effect).method_5578() < size || this.method_6112(effect).method_5584() < 600;
            if (this.hasPower() && !zaps.isEmpty() && shouldApplyEffect) {
                this.method_6092(new class_1293(effect, 1200, size));
            }
        }
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236 && this.method_5805() && !this.method_5987()) {
            class_1538 bolt = (class_1538)class_1299.field_6112.method_5883(this.method_37908());
            if (this.method_5816() && bolt != null) {
                bolt.method_29495(class_243.method_24955((class_2382)this.method_24515().method_10069(0, 1, 0)));
                this.method_37908().method_8649((class_1297)bolt);
                this.method_31472();
            }
        }
        if (this.isDashing()) {
            this.method_6035(this.method_5829(), this.method_5829());
        }
    }

    public boolean method_6121(class_1297 entity) {
        boolean hurt = super.method_6121(entity);
        if (hurt && (this.method_6047().method_7960() || this.isDashing()) && entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            this.method_37908().method_8396(null, this.method_24515(), RCSoundEvents.IMMORTAL_ELECTROSHOCK.get(), class_3419.field_15251, 1.0f, 1.0f);
            float modifier = this.method_37908().method_8404(this.method_24515()).method_5457();
            living.method_37222(new class_1293(RCMobEffects.CHANNELLED.get(), 140 * (int)modifier), (class_1297)this);
            Zap.convertToZap((class_1309)this, living);
            if (this.isDashing()) {
                entity.method_5643(this.method_48923().method_48812((class_1309)this), 16.0f);
            }
        }
        return hurt;
    }

    protected void method_6087(class_1297 entity) {
        super.method_6087(entity);
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            Zap.convertToZap((class_1309)this, living);
        }
        if (this.isDashing()) {
            this.method_6121(entity);
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source == this.method_48923().method_48809()) {
            this.restoreHealth();
            return false;
        }
        if (source == this.method_48923().method_48826() || Objects.equals(source.method_5525(), "arrow")) {
            return false;
        }
        if (this.hasPower()) {
            this.method_6092(new class_1293(class_1294.field_5904, 100));
            this.method_6092(new class_1293(class_1294.field_5907, 60, 2));
        }
        return super.method_5643(source, amount);
    }

    protected void method_6099(class_1282 source, int lootingMultiplier, boolean allowDrops) {
        super.method_6099(source, lootingMultiplier, allowDrops);
        if (allowDrops) {
            class_1799 stack = new class_1799((class_1935)class_1802.field_8547);
            stack.method_7974(stack.method_7936() - this.field_5974.method_43048(1 + this.field_5974.method_43048(Math.max(stack.method_7936() - 3, 1))));
            if (this.hasPower()) {
                if (this.field_5974.method_43057() <= 0.75f) {
                    stack.method_7978(this.field_5974.method_43056() ? class_1893.field_9117 : class_1893.field_9104, 1);
                }
                this.method_5775(stack);
            }
            if (!this.hasPower() && this.field_5974.method_43057() <= 0.1f) {
                this.method_5775(stack);
            }
        }
    }

    protected class_1799 method_7215() {
        return new class_1799((class_1935)RCBlocks.IMMORTAL_HEAD.get());
    }

    public boolean hasPower() {
        return this.method_37908().method_8546();
    }

    public void restoreHealth() {
        this.method_6033(this.method_6063());
        this.method_37908().method_8396(null, this.method_24515(), RCSoundEvents.IMMORTAL_HEAL.get(), class_3419.field_15251, 1.0f, 1.0f);
        this.method_37908().method_8406((class_2394)class_2398.field_11211, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), 0.0, 0.0, 0.0);
    }

    protected class_3414 method_5994() {
        return this.method_6510() ? RCSoundEvents.IMMORTAL_ANGRY.get() : RCSoundEvents.IMMORTAL_IDLE.get();
    }

    protected class_3414 method_6011(class_1282 source) {
        return RCSoundEvents.IMMORTAL_HURT.get();
    }

    protected class_3414 method_6002() {
        return RCSoundEvents.IMMORTAL_DEATH.get();
    }

    class SummonLightningGoal
    extends SpellcasterZombie.UseSpellGoal {
        SummonLightningGoal() {
        }

        @Override
        protected void performSpellCasting() {
            class_3218 level = (class_3218)Immortal.this.method_37908();
            if (Immortal.this.field_5974.method_43056()) {
                for (int i = 0; i <= Immortal.this.field_5974.method_43048(2); ++i) {
                    class_2338 pos = Immortal.this.method_24515().method_10069(-4 + Immortal.this.field_5974.method_43048(9), 0, -4 + Immortal.this.field_5974.method_43048(9));
                    class_1538 bolt = (class_1538)class_1299.field_6112.method_5883((class_1937)level);
                    if (bolt == null) continue;
                    bolt.method_29495(class_243.method_24955((class_2382)pos));
                    level.method_8649((class_1297)bolt);
                }
            }
        }

        @Override
        public boolean method_6264() {
            return Immortal.this.method_6032() <= Immortal.this.method_6063() / 100.0f * 80.0f && Immortal.this.hasPower() && Immortal.this.method_37908().method_8311(Immortal.this.method_24515()) && Immortal.this.field_5974.method_43056();
        }

        @Override
        protected int getCastingTime() {
            return 0;
        }

        @Override
        protected int getCastingInterval() {
            return Immortal.this.method_6032() <= Immortal.this.method_6063() / 100.0f * 40.0f ? 800 : 1600;
        }
    }

    class DashingGoal
    extends SpellcasterZombie.UseSpellGoal {
        private final Immortal immortal;

        DashingGoal(Immortal immortal) {
            this.immortal = immortal;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
        }

        @Override
        public void method_6269() {
            super.method_6269();
            this.immortal.setDashing(true);
        }

        @Override
        protected void performSpellCasting() {
            float zRot = this.immortal.method_5791();
            float xRot = this.immortal.method_36455();
            float modifier = (float)Math.PI / 180;
            float x = -class_3532.method_15374((float)(zRot * modifier)) * class_3532.method_15362((float)(xRot * modifier));
            float y = -class_3532.method_15374((float)(xRot * modifier));
            float z = class_3532.method_15362((float)(zRot * modifier)) * class_3532.method_15362((float)(xRot * modifier));
            float range = class_3532.method_15355((float)(x * x + y * y + z * z));
            float power = 4.0f;
            this.immortal.method_5762(x *= power / range, y *= power / range, z *= power / range);
            this.immortal.field_6261 = 30;
            if (!this.immortal.method_37908().field_9236) {
                this.immortal.method_6085(4, true);
            }
            if (this.immortal.method_24828()) {
                this.immortal.method_5784(class_1313.field_6308, new class_243(0.0, 1.1999999284744263, 0.0));
            }
            this.immortal.method_37908().method_43129(null, (class_1297)this.immortal, class_3417.field_14717, class_3419.field_15248, 1.0f, 1.0f);
            this.immortal.method_37908().method_43129(null, (class_1297)this.immortal, class_3417.field_14698, class_3419.field_15248, 1.0f, 1.0f);
        }

        @Override
        public void method_6268() {
            super.method_6268();
            Immortal.this.method_6035(Immortal.this.method_5829(), Immortal.this.method_5829());
        }

        public void method_6270() {
            super.method_6270();
            this.immortal.setDashing(false);
            this.immortal.restoreHealth();
        }

        @Override
        public boolean method_6264() {
            class_1309 target = this.immortal.method_5968() != null ? this.immortal.method_5968() : null;
            return target != null && this.immortal.method_5739((class_1297)target) > 8.0f && super.method_6264() && this.immortal.hasPower();
        }

        @Override
        protected int getCastingTime() {
            return 20;
        }

        @Override
        protected int getCastingInterval() {
            return 640;
        }
    }
}

