/*
 * Decompiled with CFR 0.152.
 */
package net.konwboy.tumbleweed;

import java.io.File;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;
import net.konwboy.tumbleweed.Constants;
import net.konwboy.tumbleweed.services.IConfig;
import org.apache.commons.lang3.tuple.Triple;

public class FabricConfig
implements IConfig {
    private static boolean enableDrops = true;
    private static double spawnChance = 0.5;
    private static int maxPerPlayer = 8;
    private static boolean damageCrops = true;
    private static boolean dropOnlyByPlayer = false;

    public static void load() {
        try {
            File configFile = FabricLoader.getInstance().getConfigDir().resolve("tumbleweed.properties").toFile();
            configFile.getParentFile().mkdirs();
            if (configFile.exists()) {
                Properties props = new Properties();
                props.load(new StringReader(Files.readString(configFile.toPath())));
                enableDrops = Boolean.parseBoolean((String)props.getOrDefault((Object)"enableDrops", (Object)enableDrops));
                spawnChance = Double.parseDouble((String)props.getOrDefault((Object)"spawnChance", (Object)spawnChance));
                maxPerPlayer = Integer.parseInt((String)props.getOrDefault((Object)"maxPerPlayer", (Object)maxPerPlayer));
                damageCrops = Boolean.parseBoolean((String)props.getOrDefault((Object)"damageCrops", (Object)damageCrops));
                dropOnlyByPlayer = Boolean.parseBoolean((String)props.getOrDefault((Object)"dropOnlyByPlayer", (Object)dropOnlyByPlayer));
            } else {
                StringBuilder contents = new StringBuilder();
                List<Triple> toWrite = List.of(Triple.of((Object)Constants.ENABLE_DROPS_DESC, (Object)"enableDrops", (Object)enableDrops), Triple.of((Object)Constants.SPAWN_CHANCE_DESC, (Object)"spawnChance", (Object)spawnChance), Triple.of((Object)Constants.MAX_PER_PLAYER_DESC, (Object)"maxPerPlayer", (Object)maxPerPlayer), Triple.of((Object)Constants.DAMAGE_CROPS_DESC, (Object)"damageCrops", (Object)damageCrops), Triple.of((Object)Constants.DROP_ONLY_BY_PLAYER_DESC, (Object)"dropOnlyByPlayer", (Object)dropOnlyByPlayer));
                for (Triple t : toWrite) {
                    for (String d : (String[])t.getLeft()) {
                        contents.append("#").append(d).append('\n');
                    }
                    contents.append((String)t.getMiddle()).append("=").append(t.getRight()).append('\n');
                    contents.append('\n');
                }
                Files.writeString(configFile.toPath(), (CharSequence)contents.toString(), new OpenOption[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean enableDrops() {
        return enableDrops;
    }

    @Override
    public double spawnChance() {
        return spawnChance;
    }

    @Override
    public int maxPerPlayer() {
        return maxPerPlayer;
    }

    @Override
    public boolean damageCrops() {
        return damageCrops;
    }

    @Override
    public boolean dropOnlyByPlayer() {
        return dropOnlyByPlayer;
    }
}

