/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.utils;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.api.StoneStrataHandler;
import com.almostreliable.unified.config.UnifyConfig;
import com.almostreliable.unified.utils.TagMap;
import com.almostreliable.unified.utils.TagOwnerships;
import com.almostreliable.unified.utils.UnifyTag;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class ReplacementMap {
    private final UnifyConfig unifyConfig;
    private final TagMap<class_1792> tagMap;
    private final StoneStrataHandler stoneStrataHandler;
    private final TagOwnerships tagOwnerships;
    private final Set<class_2960> warnings;

    public ReplacementMap(UnifyConfig unifyConfig, TagMap<class_1792> tagMap, StoneStrataHandler stoneStrataHandler, TagOwnerships tagOwnerships) {
        this.tagMap = tagMap;
        this.unifyConfig = unifyConfig;
        this.stoneStrataHandler = stoneStrataHandler;
        this.tagOwnerships = tagOwnerships;
        this.warnings = new HashSet<class_2960>();
    }

    @Nullable
    public UnifyTag<class_1792> getPreferredTagForItem(class_2960 item) {
        Set<UnifyTag<class_1792>> tags = this.tagMap.getTagsByEntry(item);
        if (tags.isEmpty()) {
            return null;
        }
        if (tags.size() > 1 && !this.warnings.contains(item)) {
            AlmostUnified.LOG.warn("Item '{}' has multiple preferred tags '{}' for recipe replacement. This needs to be manually fixed by the user.", (Object)item, tags.stream().map(UnifyTag::location).toList());
            this.warnings.add(item);
        }
        return (UnifyTag)tags.iterator().next();
    }

    @Nullable
    public class_2960 getReplacementForItem(class_2960 item) {
        UnifyTag<class_1792> t = this.getPreferredTagForItem(item);
        if (t == null) {
            return null;
        }
        if (this.stoneStrataHandler.isStoneStrataTag(t)) {
            String stone = this.stoneStrataHandler.getStoneStrata(item);
            return this.getPreferredItemForTag(t, i -> stone.equals(this.stoneStrataHandler.getStoneStrata((class_2960)i)));
        }
        return this.getPreferredItemForTag(t, i -> true);
    }

    @Nullable
    public class_2960 getPreferredItemForTag(UnifyTag<class_1792> tag, Predicate<class_2960> itemFilter) {
        List<class_2960> items;
        UnifyTag<class_1792> tagToLookup = this.tagOwnerships.getOwnerByTag(tag);
        if (tagToLookup == null) {
            tagToLookup = tag;
        }
        if ((items = this.tagMap.getEntriesByTag(tagToLookup).stream().filter(itemFilter).sorted(Comparator.comparingInt(value -> value.toString().length())).toList()).isEmpty()) {
            return null;
        }
        class_2960 overrideItem = this.getOverrideForTag(tagToLookup, items);
        if (overrideItem != null) {
            return overrideItem;
        }
        for (String modPriority : this.unifyConfig.getModPriorities()) {
            class_2960 item = this.findItemByNamespace(items, modPriority);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public boolean isItemInUnifiedIngredient(class_1856 ingred, class_1799 item) {
        HashSet<UnifyTag<class_1792>> checkedTags = new HashSet<UnifyTag<class_1792>>();
        for (class_1799 ingredItem : ingred.method_8105()) {
            class_2960 itemId = class_7923.field_41178.method_10221((Object)ingredItem.method_7909());
            UnifyTag<class_1792> preferredTag = this.getPreferredTagForItem(itemId);
            if (preferredTag == null || checkedTags.contains(preferredTag)) continue;
            checkedTags.add(preferredTag);
            class_6862 preferredTagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)preferredTag.location());
            if (!item.method_31573(preferredTagKey)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private class_2960 getOverrideForTag(UnifyTag<class_1792> tag, List<class_2960> items) {
        String priorityOverride = this.unifyConfig.getPriorityOverrides().get(tag.location());
        if (priorityOverride != null) {
            class_2960 item = this.findItemByNamespace(items, priorityOverride);
            if (item != null) {
                return item;
            }
            AlmostUnified.LOG.warn("Priority override mod '{}' for tag '{}' does not contain a valid item. Falling back to default priority.", (Object)priorityOverride, (Object)tag.location());
        }
        return null;
    }

    @Nullable
    private class_2960 findItemByNamespace(List<class_2960> items, String namespace) {
        for (class_2960 item : items) {
            if (!item.method_12836().equals(namespace)) continue;
            return item;
        }
        return null;
    }

    public TagOwnerships getTagOwnerships() {
        return this.tagOwnerships;
    }
}

