/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.handler;

import com.blakebr0.ironjetpacks.handler.InputHandler;
import com.blakebr0.ironjetpacks.item.JetpackItem;
import com.blakebr0.ironjetpacks.lib.ModTooltips;
import com.blakebr0.ironjetpacks.network.NetworkHandler;
import com.blakebr0.ironjetpacks.network.message.ToggleEngineMessage;
import com.blakebr0.ironjetpacks.network.message.ToggleHoverMessage;
import com.blakebr0.ironjetpacks.network.message.UpdateInputMessage;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3675;
import net.minecraft.class_5250;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class KeyBindingsHandler {
    private static class_304 keyEngine;
    private static class_304 keyHover;
    private static class_304 keyDescend;
    private static boolean up;
    private static boolean down;
    private static boolean forwards;
    private static boolean backwards;
    private static boolean left;
    private static boolean right;

    public static void onClientSetup() {
        keyEngine = KeyBindingsHandler.create("engine", 86, "Iron Jetpacks");
        keyHover = KeyBindingsHandler.create("hover", 71, "Iron Jetpacks");
        keyDescend = KeyBindingsHandler.create("descend", class_3675.field_16237.method_1444(), "Iron Jetpacks");
    }

    private static class_304 create(String id, int key, String category) {
        return KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.iron-jetpacks." + id, class_3675.class_307.field_1668, key, category));
    }

    public static void onClientTick(class_310 client) {
        KeyBindingsHandler.handleInputs(client);
        KeyBindingsHandler.updateInputs(client);
    }

    private static void handleInputs(class_310 client) {
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        class_1799 chest = player.method_6118(class_1304.field_6174);
        class_1792 item = chest.method_7909();
        if (item instanceof JetpackItem) {
            class_5250 state;
            boolean on;
            JetpackItem jetpack = (JetpackItem)item;
            while (keyEngine.method_1436()) {
                NetworkHandler.sendToServer(new ToggleEngineMessage());
                on = !jetpack.isEngineOn(chest);
                state = on ? ModTooltips.ON.color(class_124.field_1060) : ModTooltips.OFF.color(class_124.field_1061);
                player.method_7353((class_2561)ModTooltips.TOGGLE_ENGINE.args(state), true);
            }
            while (keyHover.method_1436()) {
                NetworkHandler.sendToServer(new ToggleHoverMessage());
                on = !jetpack.isHovering(chest);
                state = on ? ModTooltips.ON.color(class_124.field_1060) : ModTooltips.OFF.color(class_124.field_1061);
                player.method_7353((class_2561)ModTooltips.TOGGLE_HOVER.args(state), true);
            }
        }
    }

    public static void updateInputs(class_310 client) {
        class_315 settings = client.field_1690;
        if (client.method_1562() == null) {
            return;
        }
        boolean upNow = settings.field_1903.method_1434();
        boolean downNow = keyDescend.method_1415() ? settings.field_1832.method_1434() : keyDescend.method_1434();
        boolean forwardsNow = settings.field_1894.method_1434();
        boolean backwardsNow = settings.field_1881.method_1434();
        boolean leftNow = settings.field_1913.method_1434();
        boolean rightNow = settings.field_1849.method_1434();
        if (upNow != up || downNow != down || forwardsNow != forwards || backwardsNow != backwards || leftNow != left || rightNow != right) {
            up = upNow;
            down = downNow;
            forwards = forwardsNow;
            backwards = backwardsNow;
            left = leftNow;
            right = rightNow;
            NetworkHandler.sendToServer(new UpdateInputMessage(upNow, downNow, forwardsNow, backwardsNow, leftNow, rightNow));
            InputHandler.update((class_1657)client.field_1724, upNow, downNow, forwardsNow, backwardsNow, leftNow, rightNow);
        }
    }

    static {
        up = false;
        down = false;
        forwards = false;
        backwards = false;
        left = false;
        right = false;
    }
}

