/*
 * Decompiled with CFR 0.152.
 */
package voidedmirror.FancySporeBlossom.item;

import java.util.List;
import net.minecraft.class_1769;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public interface FancyDyeableItem {
    public static final String DISPLAY_KEY = "display";
    public static final String COLOR_KEY = "color";
    public static final String GLOWING_KEY = "glowing";
    public static final int DEFAULT_COLOR = 0xFFFFFF;

    default public boolean hasColor(class_1799 stack) {
        class_2487 tag = stack.method_7941(DISPLAY_KEY);
        return tag != null && tag.method_10573(COLOR_KEY, 99);
    }

    default public int getDyeColor(class_1799 stack) {
        class_2487 tag = stack.method_7941(DISPLAY_KEY);
        return tag != null && tag.method_10573(COLOR_KEY, 99) ? tag.method_10550(COLOR_KEY) : 0xFFFFFF;
    }

    default public boolean isGlowing(class_1799 stack) {
        class_2487 tag = stack.method_7941(DISPLAY_KEY);
        return tag != null && tag.method_10545(GLOWING_KEY) && tag.method_10577(GLOWING_KEY);
    }

    default public void removeColor(class_1799 stack) {
        class_2487 tag = stack.method_7941(DISPLAY_KEY);
        if (tag != null && tag.method_10545(COLOR_KEY)) {
            tag.method_10551(COLOR_KEY);
        }
    }

    default public void setColor(class_1799 stack, int color) {
        stack.method_7911(DISPLAY_KEY).method_10569(COLOR_KEY, color);
    }

    default public void setGlowing(class_1799 stack, boolean glow) {
        stack.method_7911(DISPLAY_KEY).method_10556(GLOWING_KEY, glow);
    }

    public static class_1799 blendAndSetColor(class_1799 stack, List<class_1769> colors) {
        class_1799 itemStack = class_1799.field_8037;
        int[] colorArray = new int[3];
        int maxValue = 0;
        int dyeNum = 0;
        FancyDyeableItem fancyDyeableItem = null;
        if (stack.method_7909() instanceof FancyDyeableItem) {
            fancyDyeableItem = (FancyDyeableItem)stack.method_7909();
            itemStack = stack.method_7972();
            itemStack.method_7939(1);
            if (fancyDyeableItem.hasColor(stack)) {
                int color = fancyDyeableItem.getDyeColor(itemStack);
                float blue = (float)(color >> 16 & 0xFF) / 255.0f;
                float green = (float)(color >> 8 & 0xFF) / 255.0f;
                float red = (float)(color & 0xFF) / 255.0f;
                maxValue += (int)(Math.max(blue, Math.max(green, red)) * 255.0f);
                colorArray[0] = colorArray[0] + (int)(blue * 255.0f);
                colorArray[1] = colorArray[1] + (int)(green * 255.0f);
                colorArray[2] = colorArray[2] + (int)(red * 255.0f);
                ++dyeNum;
            }
            for (class_1769 dyeItem : colors) {
                float[] diffuseColors = dyeItem.method_7802().method_7787();
                int r = (int)(diffuseColors[0] * 255.0f);
                int g = (int)(diffuseColors[1] * 255.0f);
                int b = (int)(diffuseColors[2] * 255.0f);
                maxValue += Math.max(r, Math.max(g, b));
                colorArray[0] = colorArray[0] + r;
                colorArray[1] = colorArray[1] + g;
                colorArray[2] = colorArray[2] + b;
                ++dyeNum;
            }
        }
        if (fancyDyeableItem == null) {
            return class_1799.field_8037;
        }
        int redNorm = colorArray[0] / dyeNum;
        int greenNorm = colorArray[1] / dyeNum;
        int blueNorm = colorArray[2] / dyeNum;
        float maxNormValue = (float)maxValue / (float)dyeNum;
        float maxNorm = Math.max(redNorm, Math.max(greenNorm, blueNorm));
        redNorm = (int)((float)redNorm * maxNormValue / maxNorm);
        greenNorm = (int)((float)greenNorm * maxNormValue / maxNorm);
        blueNorm = (int)((float)blueNorm * maxNormValue / maxNorm);
        int colorOut = redNorm;
        colorOut = (colorOut << 8) + greenNorm;
        colorOut = (colorOut << 8) + blueNorm;
        fancyDyeableItem.setColor(itemStack, colorOut);
        return itemStack;
    }

    public static class_1799 buildItemStack(class_1799 stack, List<class_1769> colors, boolean isGlowing) {
        class_1799 itemStack = stack.method_7972();
        if (!colors.isEmpty()) {
            itemStack = FancyDyeableItem.blendAndSetColor(stack, colors);
        }
        ((FancyDyeableItem)itemStack.method_7909()).setGlowing(itemStack, isGlowing);
        itemStack.method_7939(1);
        return itemStack;
    }
}

