/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.pockettools.item;

import dev.emi.pockettools.tooltip.ConvertibleTooltipData;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1874;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2609;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3956;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import net.minecraft.class_5684;

public class PocketFurnace<T extends class_1874>
extends class_1792 {
    private class_3956<T> type;

    public PocketFurnace(class_3956<T> type, class_1792.class_1793 settings) {
        super(settings);
        this.type = type;
    }

    public boolean method_31567(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        if (nbt.method_10545("cookTime") && nbt.method_10545("fuelTime")) {
            int cookTime = nbt.method_10550("cookTime");
            int fuelTime = nbt.method_10550("fuelTime");
            return cookTime > 0 && fuelTime > 0;
        }
        return false;
    }

    public int method_31569(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        if (nbt.method_10545("cookTime") && nbt.method_10545("maxCookTime")) {
            int cookTime = nbt.method_10550("cookTime");
            int maxCookTime = nbt.method_10550("maxCookTime");
            return Math.round((float)(maxCookTime - cookTime) / (float)maxCookTime * 13.0f);
        }
        return 0;
    }

    public int method_31571(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        if (nbt.method_10545("cookTime")) {
            return class_3532.method_15353((float)0.0f, (float)150.0f, (float)150.0f);
        }
        return class_3532.method_15353((float)0.0f, (float)150.0f, (float)150.0f);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (!world.method_8608()) {
            class_2487 nbt = stack.method_7948();
            class_1799 input = class_1799.field_8037;
            class_1799 fuel = class_1799.field_8037;
            class_1799 output = class_1799.field_8037;
            int fuelTime = 0;
            int cookTime = 0;
            int customModelData = 0;
            if (nbt.method_10545("input")) {
                input = class_1799.method_7915((class_2487)nbt.method_10562("input"));
            }
            if (nbt.method_10545("fuel")) {
                fuel = class_1799.method_7915((class_2487)nbt.method_10562("fuel"));
            }
            if (nbt.method_10545("output")) {
                output = class_1799.method_7915((class_2487)nbt.method_10562("output"));
            }
            if (nbt.method_10545("fuelTime")) {
                fuelTime = nbt.method_10550("fuelTime");
            }
            if (nbt.method_10545("cookTime")) {
                cookTime = nbt.method_10550("cookTime");
            }
            if (nbt.method_10545("CustomModelData")) {
                customModelData = nbt.method_10550("CustomModelData");
            }
            if (cookTime > 0) {
                if (fuelTime > 0) {
                    nbt.method_10569("fuelTime", --fuelTime);
                }
                if (fuelTime == 0) {
                    if (fuel.method_7947() > 0) {
                        fuelTime = class_2609.method_11196().getOrDefault(fuel.method_7909(), 0);
                        nbt.method_10569("fuelTime", fuelTime);
                        nbt.method_10569("maxFuelTime", fuelTime);
                        fuel.method_7934(1);
                        nbt.method_10566("fuel", (class_2520)fuel.method_7953(new class_2487()));
                    } else {
                        return;
                    }
                }
                if (--cookTime == 0) {
                    Optional recipe = world.method_8433().method_8132(this.type, (class_1263)new class_1277(new class_1799[]{input}), world);
                    if (recipe.isPresent()) {
                        class_1799 recipeOutput = ((class_1874)recipe.get()).method_8110(world.method_30349());
                        if (output.method_7960()) {
                            output = recipeOutput.method_7972();
                        } else if (class_1799.method_7984((class_1799)output, (class_1799)recipeOutput)) {
                            output.method_7933(1);
                        }
                        nbt.method_10566("output", (class_2520)output.method_7953(new class_2487()));
                        if (output.method_7947() < output.method_7914() && input.method_7947() > 1) {
                            cookTime = ((class_1874)recipe.get()).method_8167();
                            nbt.method_10569("maxCookTime", cookTime);
                        }
                    }
                    input.method_7934(1);
                    nbt.method_10566("input", (class_2520)input.method_7953(new class_2487()));
                }
                nbt.method_10569("cookTime", cookTime);
            } else {
                Optional recipe;
                if (fuelTime > 0) {
                    nbt.method_10569("fuelTime", --fuelTime);
                }
                if (output.method_7947() < output.method_7914() && input.method_7947() > 0 && (recipe = world.method_8433().method_8132(this.type, (class_1263)new class_1277(new class_1799[]{input}), world)).isPresent() && (output.method_7960() || class_1799.method_7984((class_1799)output, (class_1799)((class_1874)recipe.get()).method_8110(world.method_30349())) && output.method_7947() < output.method_7914())) {
                    cookTime = ((class_1874)recipe.get()).method_8167();
                    nbt.method_10569("cookTime", cookTime);
                    nbt.method_10569("maxCookTime", cookTime);
                }
            }
            if (customModelData == 0 != (fuelTime == 0)) {
                nbt.method_10569("CustomModelData", 1 - customModelData);
            }
        }
    }

    public boolean method_31566(class_1799 stack, class_1799 applied, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursor) {
        class_2487 nbt = stack.method_7948();
        if (clickType == class_5536.field_27014) {
            if (applied.method_7960() && nbt.method_10545("output")) {
                class_1799 output = class_1799.method_7915((class_2487)nbt.method_10562("output"));
                cursor.method_32332(output.method_7972());
                nbt.method_10551("output");
                return true;
            }
            class_1799 input = class_1799.field_8037;
            if (nbt.method_10545("input")) {
                input = class_1799.method_7915((class_2487)nbt.method_10562("input"));
            }
            if (!input.method_7960() && class_1799.method_7984((class_1799)input, (class_1799)applied) || input.method_7960() && this.isSmeltable(player.method_37908(), applied)) {
                if (input.method_7960()) {
                    input = applied.method_7972();
                    applied.method_7939(0);
                } else if (input.method_7947() + applied.method_7947() > input.method_7914()) {
                    applied.method_7939(input.method_7947() + applied.method_7947() - input.method_7914());
                    input.method_7939(input.method_7914());
                } else {
                    input.method_7939(input.method_7947() + applied.method_7947());
                    applied.method_7939(0);
                }
                nbt.method_10566("input", (class_2520)input.method_7953(new class_2487()));
                stack.method_7980(nbt);
                return true;
            }
            class_1799 fuel = class_1799.field_8037;
            if (nbt.method_10545("fuel")) {
                fuel = class_1799.method_7915((class_2487)nbt.method_10562("fuel"));
            }
            if (!fuel.method_7960() && class_1799.method_7984((class_1799)fuel, (class_1799)applied) || fuel.method_7960() && class_2609.method_11195((class_1799)applied)) {
                if (fuel.method_7960()) {
                    fuel = applied.method_7972();
                    applied.method_7939(0);
                } else if (fuel.method_7947() + applied.method_7947() > fuel.method_7914()) {
                    applied.method_7939(fuel.method_7947() + applied.method_7947() - fuel.method_7914());
                    fuel.method_7939(fuel.method_7914());
                } else {
                    fuel.method_7939(fuel.method_7947() + applied.method_7947());
                    applied.method_7939(0);
                }
                nbt.method_10566("fuel", (class_2520)fuel.method_7953(new class_2487()));
                stack.method_7980(nbt);
                return true;
            }
        }
        return false;
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        return Optional.of(new PocketFurnaceTooltip(stack));
    }

    protected boolean isSmeltable(class_1937 world, class_1799 itemStack) {
        return world.method_8433().method_8132(this.type, (class_1263)new class_1277(new class_1799[]{itemStack}), world).isPresent();
    }

    static class PocketFurnaceTooltip
    implements ConvertibleTooltipData,
    class_5684 {
        private final class_2960 FURNACE = new class_2960("pockettools", "textures/gui/component/furnace.png");
        public class_1799 stack;

        public PocketFurnaceTooltip(class_1799 stack) {
            this.stack = stack;
        }

        @Override
        public class_5684 getComponent() {
            return this;
        }

        public int method_32661() {
            return 40;
        }

        public int method_32664(class_327 textRenderer) {
            return 66;
        }

        public void method_32666(class_327 textRenderer, int x, int y, class_332 context) {
            class_2487 nbt = this.stack.method_7948();
            class_1799 input = class_1799.field_8037;
            class_1799 fuel = class_1799.field_8037;
            class_1799 output = class_1799.field_8037;
            int fuelTime = 0;
            int cookTime = 0;
            int maxFuelTime = 0;
            int maxCookTime = 0;
            if (nbt.method_10545("input")) {
                input = class_1799.method_7915((class_2487)nbt.method_10562("input"));
            }
            if (nbt.method_10545("fuel")) {
                fuel = class_1799.method_7915((class_2487)nbt.method_10562("fuel"));
            }
            if (nbt.method_10545("output")) {
                output = class_1799.method_7915((class_2487)nbt.method_10562("output"));
            }
            if (nbt.method_10545("fuelTime")) {
                fuelTime = nbt.method_10550("fuelTime");
            }
            if (nbt.method_10545("cookTime")) {
                cookTime = nbt.method_10550("cookTime");
            }
            if (nbt.method_10545("maxFuelTime")) {
                maxFuelTime = nbt.method_10550("maxFuelTime");
            }
            if (nbt.method_10545("maxCookTime")) {
                maxCookTime = nbt.method_10550("maxCookTime");
            }
            this.renderGuiItem(context, textRenderer, input, x + 2, y + 1);
            this.renderGuiItem(context, textRenderer, output, x + 48, y + 2);
            this.renderGuiItem(context, textRenderer, fuel, x + 2, y + 20);
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            if (maxFuelTime > 0) {
                int fuelProgress = fuelTime * 13 / maxFuelTime;
                context.method_25290(this.FURNACE, x + 26, y + 36 - fuelProgress, 0.0f, (float)(13 - fuelProgress), 13, fuelProgress + 1, 256, 256);
            }
            if (cookTime > 0 && maxCookTime > 0) {
                int cookProgress = 22 - cookTime * 22 / maxCookTime;
                context.method_25290(this.FURNACE, x + 22, y + 3, 0.0f, 13.0f, cookProgress, 15, 256, 256);
            }
        }

        private void renderGuiItem(class_332 context, class_327 textRenderer, class_1799 stack, int x, int y) {
            context.method_51427(stack, x, y);
            context.method_51431(textRenderer, stack, x, y);
        }
    }
}

