/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack;

import com.mojang.authlib.minecraft.client.ObjectMapper;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.compat.trinkets.TravelersBackpackTrinketIntegration;
import com.tiviacz.travelersbackpack.compat.universalgraves.UniversalGravesCompat;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.fluids.EffectFluidRegistry;
import com.tiviacz.travelersbackpack.handlers.DeathHandler;
import com.tiviacz.travelersbackpack.handlers.EntityItemHandler;
import com.tiviacz.travelersbackpack.handlers.LootHandler;
import com.tiviacz.travelersbackpack.handlers.RightClickHandler;
import com.tiviacz.travelersbackpack.handlers.SleepHandler;
import com.tiviacz.travelersbackpack.handlers.TickHandler;
import com.tiviacz.travelersbackpack.handlers.TradeOffersHandler;
import com.tiviacz.travelersbackpack.init.ModBlockEntityTypes;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModCommands;
import com.tiviacz.travelersbackpack.init.ModCreativeTabs;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.init.ModMenuTypes;
import com.tiviacz.travelersbackpack.init.ModNetwork;
import com.tiviacz.travelersbackpack.init.ModRecipeSerializers;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.Supporters;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TravelersBackpack
implements ModInitializer {
    public static final String MODID = "travelersbackpack";
    public static final Logger LOGGER = LogManager.getLogger();
    public static boolean accessoriesLoaded;
    public static boolean trinketsLoaded;
    public static boolean craftingTweaksLoaded;
    public static boolean toughasnailsLoaded;
    public static boolean comfortsLoaded;
    public static boolean universalGravesLoaded;
    public static boolean polymorphLoaded;
    private static boolean needReplacement;

    public void onInitialize() {
        TravelersBackpack.readOldCommonConfig();
        TravelersBackpackConfig.register();
        ModCreativeTabs.registerItemGroup();
        ModBlocks.init();
        ModItems.init();
        ModBlockEntityTypes.init();
        ModBlockEntityTypes.initSidedStorage();
        ModMenuTypes.init();
        ModRecipeSerializers.init();
        ModNetwork.initServer();
        ModCommands.registerCommands();
        EntityItemHandler.registerListeners();
        LootHandler.registerListeners();
        TradeOffersHandler.init();
        RightClickHandler.registerListeners();
        SleepHandler.registerListener();
        this.registerDeathHandler();
        TravelersBackpackBlock.registerDispenserBehaviour();
        TickHandler.register();
        ModCreativeTabs.addItemGroup();
        TravelersBackpackItem.registerCauldronInteraction();
        accessoriesLoaded = FabricLoader.getInstance().isModLoaded("accessories");
        trinketsLoaded = FabricLoader.getInstance().isModLoaded("trinkets");
        craftingTweaksLoaded = FabricLoader.getInstance().isModLoaded("craftingtweaks");
        if (trinketsLoaded) {
            TravelersBackpackTrinketIntegration.init();
        }
        toughasnailsLoaded = FabricLoader.getInstance().isModLoaded("toughasnails");
        comfortsLoaded = FabricLoader.getInstance().isModLoaded("comforts");
        universalGravesLoaded = FabricLoader.getInstance().isModLoaded("universal-graves");
        if (universalGravesLoaded) {
            UniversalGravesCompat.register();
        }
        polymorphLoaded = FabricLoader.getInstance().isModLoaded("polymorph");
        EffectFluidRegistry.initEffects();
        Supporters.fetchSupporters();
        TravelersBackpack.replaceNewConfigValue();
    }

    public void registerDeathHandler() {
        DeathHandler.registerListeners();
    }

    public static boolean enableIntegration() {
        return TravelersBackpack.enableTrinkets();
    }

    public static boolean enableTrinkets() {
        return trinketsLoaded && TravelersBackpackConfig.getConfig().backpackSettings.trinketsIntegration;
    }

    public static boolean isAnyGraveModInstalled() {
        return universalGravesLoaded;
    }

    public static void readOldCommonConfig() {
        try {
            Path path = FabricLoader.getInstance().getConfigDir().resolve("travelersbackpack.json5");
            String content = new String(Files.readAllBytes(path));
            content = content.replaceAll("//.*?$", "");
            content = content.replaceAll("/\\*.*?\\*/", "");
            ObjectMapper mapper = ObjectMapper.create();
            Map jsonMap = (Map)mapper.readValue(content, Map.class);
            if (jsonMap == null) {
                return;
            }
            if (jsonMap.containsKey("backpackUpgrades")) {
                return;
            }
            Map backpackSettings = (Map)jsonMap.get("backpackSettings");
            Boolean trinketsIntegration = (Boolean)backpackSettings.get("trinketsIntegration");
            if (!trinketsIntegration.booleanValue()) {
                needReplacement = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void replaceNewConfigValue() {
        if (!needReplacement) {
            return;
        }
        try {
            Path path = FabricLoader.getInstance().getConfigDir().resolve("travelersbackpack.json5");
            String content = new String(Files.readAllBytes(path));
            String searchKey = "\"trinketsIntegration\":";
            String newValue = "\"trinketsIntegration\": false";
            String updatedContent = content.replaceFirst(searchKey + ".*?(,|\n)", newValue + "$1");
            Files.write(path, updatedContent.getBytes(), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        needReplacement = false;
    }
}

