/*
 * Decompiled with CFR 0.152.
 */
package io.github.adytech99.healthindicators;

import com.terraformersmc.modmenu.ModMenu;
import io.github.adytech99.healthindicators.RenderTracker;
import io.github.adytech99.healthindicators.commands.ModCommands;
import io.github.adytech99.healthindicators.config.Config;
import io.github.adytech99.healthindicators.config.ModConfig;
import io.github.adytech99.healthindicators.enums.MessageTypeEnum;
import io.github.adytech99.healthindicators.util.ConfigUtils;
import io.github.adytech99.healthindicators.util.Maths;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class HealthIndicatorsMod
implements ClientModInitializer {
    public static final String MOD_ID = "healthindicators";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"healthindicators");
    public static final String CONFIG_FILE = "healthindicators.json";
    public static final class_304 RENDERING_ENABLED_KEY_BINDING = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.healthindicators.renderingEnabled", 263, "key.categories.healthindicators"));
    public static final class_304 OVERRIDE_ALL_FILTERS = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.healthindicators.overrideAllFilters", 262, "key.categories.healthindicators"));
    public static final class_304 INCREASE_HEART_OFFSET_KEY_BINDING = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.healthindicators.increaseHeartOffset", 265, "key.categories.healthindicators"));
    public static final class_304 DECREASE_HEART_OFFSET_KEY_BINDING = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.healthindicators.decreaseHeartOffset", 264, "key.categories.healthindicators"));
    private boolean changed = false;
    private static boolean openConfig = false;

    public static void openConfig(class_310 client) {
        openConfig = client.field_1687 != null;
    }

    public void onInitializeClient() {
        ModConfig.HANDLER.load();
        Config.load();
        if (((ModConfig)ModConfig.HANDLER.instance()).enable_commands) {
            ModCommands.registerCommands();
        }
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            boolean overlay;
            if (openConfig) {
                class_437 configScreen = ModMenu.getConfigScreen((String)MOD_ID, (class_437)client.field_1755);
                client.method_1507(configScreen);
                openConfig = false;
            }
            boolean bl = overlay = ((ModConfig)ModConfig.HANDLER.instance()).message_type == MessageTypeEnum.ACTIONBAR;
            while (RENDERING_ENABLED_KEY_BINDING.method_1436()) {
                Config.setRenderingEnabled(!Config.getRenderingEnabled());
                if (client.field_1724 == null) continue;
                class_124 formatting = ((ModConfig)ModConfig.HANDLER.instance()).colored_messages ? (Config.getRenderingEnabled() ? class_124.field_1060 : class_124.field_1061) : class_124.field_1068;
                ConfigUtils.sendMessage(client.field_1724, (class_2561)class_2561.method_43470((String)((Config.getRenderingEnabled() ? "Enabled" : "Disabled") + " Health Indicators")).method_27692(formatting));
            }
            if (OVERRIDE_ALL_FILTERS.method_1434()) {
                Config.setOverrideAllFiltersEnabled(true);
                if (client.field_1724 != null) {
                    ConfigUtils.sendOverlayMessage(client.field_1724, (class_2561)class_2561.method_43470((String)(" Config Criteria " + (Config.getOverrideAllFiltersEnabled() ? "Temporarily Overridden" : "Re-implemented"))));
                }
            } else if (Config.getOverrideAllFiltersEnabled()) {
                Config.setOverrideAllFiltersEnabled(false);
                client.field_1705.method_1758((class_2561)class_2561.method_43470((String)""), false);
            }
            while (INCREASE_HEART_OFFSET_KEY_BINDING.method_1436()) {
                ((ModConfig)ModConfig.HANDLER.instance()).display_offset += ((ModConfig)ModConfig.HANDLER.instance()).offset_step_size;
                this.changed = true;
                if (client.field_1724 == null) continue;
                ConfigUtils.sendMessage(client.field_1724, (class_2561)class_2561.method_43470((String)("Set heart offset to " + Maths.truncate(((ModConfig)ModConfig.HANDLER.instance()).display_offset, 2))));
            }
            while (DECREASE_HEART_OFFSET_KEY_BINDING.method_1436()) {
                ((ModConfig)ModConfig.HANDLER.instance()).display_offset -= ((ModConfig)ModConfig.HANDLER.instance()).offset_step_size;
                this.changed = true;
                if (client.field_1724 == null) continue;
                ConfigUtils.sendMessage(client.field_1724, (class_2561)class_2561.method_43470((String)("Set heart offset to " + Maths.truncate(((ModConfig)ModConfig.HANDLER.instance()).display_offset, 2))));
            }
        });
        ClientEntityEvents.ENTITY_UNLOAD.register((entity, world) -> RenderTracker.removeFromUUIDS(entity));
        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            if (client.field_1687 == null) {
                return;
            }
            if (this.changed && client.field_1687.method_8510() % 200L == 0L) {
                this.saveModConfig();
                this.changed = false;
            }
        });
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> this.saveModConfig());
        ClientTickEvents.END_CLIENT_TICK.register(RenderTracker::tick);
        LOGGER.info("Never be heartless!");
    }

    public void saveModConfig() {
        ModConfig.HANDLER.save();
    }
}

