/*
 * Decompiled with CFR 0.152.
 */
package io.github.adytech99.healthindicators.config;

import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.autogen.AutoGen;
import dev.isxander.yacl3.config.v2.api.autogen.Boolean;
import dev.isxander.yacl3.config.v2.api.autogen.ColorField;
import dev.isxander.yacl3.config.v2.api.autogen.DoubleField;
import dev.isxander.yacl3.config.v2.api.autogen.DoubleSlider;
import dev.isxander.yacl3.config.v2.api.autogen.EnumCycler;
import dev.isxander.yacl3.config.v2.api.autogen.IntField;
import dev.isxander.yacl3.config.v2.api.autogen.IntSlider;
import dev.isxander.yacl3.config.v2.api.autogen.Label;
import dev.isxander.yacl3.config.v2.api.autogen.MasterTickBox;
import dev.isxander.yacl3.config.v2.api.autogen.TickBox;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import io.github.adytech99.healthindicators.enums.HealthDisplayTypeEnum;
import io.github.adytech99.healthindicators.enums.MessageTypeEnum;
import java.awt.Color;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class ModConfig {
    public static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("health_indicators_config.json");
    public static final ConfigClassHandler<ModConfig> HANDLER = ConfigClassHandler.createBuilder(ModConfig.class).id(new class_2960("health-indicators", "config")).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(CONFIG_PATH).build()).build();
    @Label
    @AutoGen(category="filters")
    private final class_2561 filtersProTip = class_2561.method_43470((String)"Pro Tip: You can temporarily override the below criteria and force health display for all living entities by holding the Right-Arrow key (customizable)").method_27692(class_124.field_1065);
    @Label
    private final class_2561 filtersTypeLabel = class_2561.method_43470((String)"Enable health display based on entity type").method_27695(new class_124[]{class_124.field_1067, class_124.field_1075});
    @SerialEntry
    @AutoGen(category="filters", group="entity_type")
    @TickBox
    public boolean passive_mobs = true;
    @SerialEntry
    @AutoGen(category="filters", group="entity_type")
    @TickBox
    public boolean hostile_mobs = true;
    @SerialEntry
    @AutoGen(category="filters", group="entity_type")
    @MasterTickBox(value={"override_players"})
    public boolean players = true;
    @SerialEntry
    @AutoGen(category="filters", group="entity_type")
    @TickBox
    public boolean self = false;
    @Label
    private final class_2561 filtersAdvancedLabel = class_2561.method_43470((String)"Enable health display based on additional misc. criteria").method_27695(new class_124[]{class_124.field_1067, class_124.field_1075});
    @SerialEntry
    @AutoGen(category="filters", group="advanced")
    @MasterTickBox(value={"override_players", "time_after_hit"})
    public boolean after_attack = false;
    @SerialEntry
    @AutoGen(category="filters", group="advanced")
    @IntSlider(min=0, max=120, step=1)
    public int time_after_hit = 60;
    @Label
    @AutoGen(category="filters", group="advanced")
    private final class_2561 damaged_only_label = class_2561.method_43470((String)" ").method_27692(class_124.field_1056);
    @SerialEntry
    @AutoGen(category="filters", group="advanced")
    @MasterTickBox(value={"override_players"})
    public boolean damaged_only = false;
    @Label
    @AutoGen(category="filters", group="advanced")
    private final class_2561 on_crosshair_label = class_2561.method_43470((String)" ").method_27692(class_124.field_1056);
    @SerialEntry
    @AutoGen(category="filters", group="advanced")
    @MasterTickBox(value={"override_players", "reach"})
    public boolean looking_at = false;
    @SerialEntry
    @AutoGen(category="filters", group="advanced")
    @IntField(min=0, max=1024)
    public int reach = 3;
    @Label
    @AutoGen(category="filters", group="advanced")
    private final class_2561 override_players_label = class_2561.method_43470((String)"Overrides").method_27692(class_124.field_1056);
    @SerialEntry
    @AutoGen(category="filters", group="advanced")
    @TickBox
    public boolean override_players = true;
    @SerialEntry
    @AutoGen(category="appearance", group="indicator_type")
    @EnumCycler
    public HealthDisplayTypeEnum indicator_type = HealthDisplayTypeEnum.HEARTS;
    @AutoGen(category="appearance", group="indicator_type")
    @Label
    private final class_2561 heart_type_settings_label = class_2561.method_43470((String)"Settings for the heart-type indicator");
    @SerialEntry
    @AutoGen(category="appearance", group="indicator_type")
    @IntField
    public int hearts_per_row = 10;
    @AutoGen(category="appearance", group="indicator_type")
    @Label
    private final class_2561 number_type_settings_label = class_2561.method_43470((String)"Settings for the number-type indicator");
    @SerialEntry
    @AutoGen(category="appearance", group="indicator_type")
    @ColorField
    public Color number_color = Color.RED;
    @SerialEntry
    @AutoGen(category="appearance", group="indicator_type")
    @Boolean
    public boolean render_number_display_shadow = false;
    @SerialEntry
    @AutoGen(category="appearance", group="indicator_type")
    @MasterTickBox(value={"number_display_background_color"})
    public boolean render_number_display_background_color = true;
    @SerialEntry
    @AutoGen(category="appearance", group="indicator_type")
    @ColorField
    public Color number_display_background_color = Color.BLACK;
    @SerialEntry
    @AutoGen(category="appearance", group="offset")
    @DoubleField
    public double display_offset = 0.0;
    @SerialEntry
    @AutoGen(category="appearance", group="offset")
    @DoubleSlider(min=0.0, max=10.0, step=0.5)
    public double offset_step_size = 1.0;
    @SerialEntry
    @AutoGen(category="appearance", group="offset")
    @Boolean
    public boolean force_higher_offset_for_players = false;
    @SerialEntry
    @AutoGen(category="messages", group="messages_appearance")
    @EnumCycler
    public MessageTypeEnum message_type = MessageTypeEnum.ACTIONBAR;
    @SerialEntry
    @AutoGen(category="messages", group="messages_appearance")
    @Boolean(colored=true)
    public boolean colored_messages = true;
    @Label
    @AutoGen(category="messages", group="commands")
    private final class_2561 commandsRestartWarning = class_2561.method_43470((String)"For this section, a restart is required to apply any modifications").method_27692(class_124.field_1061);
    @SerialEntry
    @AutoGen(category="messages", group="commands")
    @Boolean(formatter=Boolean.Formatter.YES_NO)
    public boolean enable_commands = true;

    public static class_437 createScreen(@Nullable class_437 parent) {
        return HANDLER.generateGui().generateScreen(parent);
    }

    public class_437 createConfigScreen(class_437 parent) {
        if (FabricLoader.getInstance().isModLoaded("yet_another_config_lib_v3")) {
            return ModConfig.createScreen(parent);
        }
        return null;
    }
}

