/*
 * Decompiled with CFR 0.152.
 */
package io.github.adytech99.healthindicators.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.adytech99.healthindicators.RenderTracker;
import io.github.adytech99.healthindicators.config.Config;
import io.github.adytech99.healthindicators.config.ModConfig;
import io.github.adytech99.healthindicators.enums.HealthDisplayTypeEnum;
import io.github.adytech99.healthindicators.enums.HeartType;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_757;
import net.minecraft.class_897;
import net.minecraft.class_922;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_922.class})
public abstract class NewEntityRendererMixin<T extends class_1309, M extends class_583<T>>
extends class_897<T>
implements class_3883<T, M> {
    @Unique
    private static final class_2960 ICONS = new class_2960("textures/gui/icons.png");
    @Unique
    private final class_310 client = class_310.method_1551();

    protected NewEntityRendererMixin(class_5617.class_5618 ctx) {
        super(ctx);
    }

    @Inject(method={"render(Lnet/minecraft/entity/LivingEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at={@At(value="TAIL")})
    public void render(T livingEntity, float yaw, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, CallbackInfo ci) {
        if (RenderTracker.isInUUIDS(livingEntity) || Config.getOverrideAllFiltersEnabled() && !RenderTracker.isInvalid(livingEntity)) {
            if (!(!((ModConfig)ModConfig.HANDLER.instance()).looking_at || RenderTracker.isTargeted(livingEntity) || Config.getOverrideAllFiltersEnabled() || livingEntity instanceof class_1657 && ((ModConfig)ModConfig.HANDLER.instance()).override_players || livingEntity == this.client.field_1724)) {
                return;
            }
            if (((ModConfig)ModConfig.HANDLER.instance()).indicator_type == HealthDisplayTypeEnum.HEARTS) {
                this.renderHearts(livingEntity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
            } else if (((ModConfig)ModConfig.HANDLER.instance()).indicator_type == HealthDisplayTypeEnum.NUMBER) {
                this.renderNumber(livingEntity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
            }
        }
    }

    @Unique
    private void renderHearts(T livingEntity, float yaw, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light) {
        matrixStack.method_22903();
        double d = this.field_4676.method_23168(livingEntity);
        matrixStack.method_46416(0.0f, livingEntity.method_17682() + 0.5f, 0.0f);
        if ((this.method_3921((class_1297)livingEntity) || ((ModConfig)ModConfig.HANDLER.instance()).force_higher_offset_for_players && livingEntity instanceof class_1657 && livingEntity != this.client.field_1724) && d <= 4096.0) {
            matrixStack.method_22904(0.0, (double)0.25875f, 0.0);
            if (d < 100.0 && livingEntity.method_5770().method_8428().method_1189(2) != null) {
                matrixStack.method_22904(0.0, (double)0.25875f, 0.0);
            }
        }
        matrixStack.method_22907(this.field_4676.method_24197());
        float pixelSize = 0.025f;
        matrixStack.method_22905(pixelSize, pixelSize, pixelSize);
        matrixStack.method_22904(0.0, ((ModConfig)ModConfig.HANDLER.instance()).display_offset, 0.0);
        class_289 tessellator = class_289.method_1348();
        class_287 vertexConsumer = tessellator.method_1349();
        vertexConsumer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)ICONS);
        RenderSystem.enableDepthTest();
        Matrix4f model = matrixStack.method_23760().method_23761();
        int healthRed = class_3532.method_15386((float)livingEntity.method_6032());
        int maxHealth = class_3532.method_15386((float)livingEntity.method_6063());
        int healthYellow = class_3532.method_15386((float)livingEntity.method_6067());
        int heartsRed = class_3532.method_15386((float)((float)healthRed / 2.0f));
        boolean lastRedHalf = (healthRed & 1) == 1;
        int heartsNormal = class_3532.method_15386((float)((float)maxHealth / 2.0f));
        int heartsYellow = class_3532.method_15386((float)((float)healthYellow / 2.0f));
        boolean lastYellowHalf = (healthYellow & 1) == 1;
        int heartsTotal = heartsNormal + heartsYellow;
        int heartsPerRow = ((ModConfig)ModConfig.HANDLER.instance()).hearts_per_row;
        int rowsTotal = (heartsTotal + heartsPerRow - 1) / heartsPerRow;
        int rowOffset = Math.max(10 - (rowsTotal - 2), 3);
        int pixelsTotal = Math.min(heartsTotal, heartsPerRow) * 8 + 1;
        float maxX = (float)pixelsTotal / 2.0f;
        for (int heart = 0; heart < heartsTotal; ++heart) {
            HeartType type;
            int row = heart / heartsPerRow;
            int col = heart % heartsPerRow;
            float x = maxX - (float)(col * 8);
            float y = row * rowOffset;
            float z = (float)row * 0.01f;
            NewEntityRendererMixin.drawHeart(model, (class_4588)vertexConsumer, x, y, z, HeartType.EMPTY);
            if (heart < heartsRed) {
                type = HeartType.RED_FULL;
                if (heart == heartsRed - 1 && lastRedHalf) {
                    type = HeartType.RED_HALF;
                }
            } else if (heart < heartsNormal) {
                type = HeartType.EMPTY;
            } else {
                type = HeartType.YELLOW_FULL;
                if (heart == heartsTotal - 1 && lastYellowHalf) {
                    type = HeartType.YELLOW_HALF;
                }
            }
            if (type == HeartType.EMPTY) continue;
            NewEntityRendererMixin.drawHeart(model, (class_4588)vertexConsumer, x, y, z, type);
        }
        tessellator.method_1350();
        matrixStack.method_22909();
    }

    @Unique
    private void renderNumber(T livingEntity, float yaw, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light) {
        double d = this.field_4676.method_23168(livingEntity);
        int health = class_3532.method_15386((float)livingEntity.method_6032());
        int maxHealth = class_3532.method_15386((float)livingEntity.method_6063());
        int absorption = class_3532.method_15386((float)livingEntity.method_6067());
        String healthText = health + absorption + " / " + maxHealth;
        matrixStack.method_22903();
        float scale = 0.025f;
        matrixStack.method_46416(0.0f, livingEntity.method_17682() + 0.5f, 0.0f);
        if ((this.method_3921((class_1297)livingEntity) || ((ModConfig)ModConfig.HANDLER.instance()).force_higher_offset_for_players && livingEntity instanceof class_1657 && livingEntity != this.client.field_1724) && d <= 4096.0) {
            matrixStack.method_22904(0.0, (double)(10.349999f * scale), 0.0);
            if (d < 100.0 && livingEntity instanceof class_1657 && livingEntity.method_5770().method_8428().method_1189(0) != null) {
                matrixStack.method_22904(0.0, (double)(10.349999f * scale), 0.0);
            }
        }
        matrixStack.method_22907(this.field_4676.method_24197());
        matrixStack.method_22905(-scale, -scale, scale);
        matrixStack.method_22904(0.0, -((ModConfig)ModConfig.HANDLER.instance()).display_offset, 0.0);
        class_327 textRenderer = class_310.method_1551().field_1772;
        float x = (float)(-textRenderer.method_1727(healthText)) / 2.0f;
        Matrix4f model = matrixStack.method_23760().method_23761();
        textRenderer.method_27521(healthText, x, 0.0f, ((ModConfig)ModConfig.HANDLER.instance()).number_color.getRGB(), ((ModConfig)ModConfig.HANDLER.instance()).render_number_display_shadow, model, vertexConsumerProvider, class_327.class_6415.field_33993, ((ModConfig)ModConfig.HANDLER.instance()).render_number_display_background_color ? ((ModConfig)ModConfig.HANDLER.instance()).number_display_background_color.getRGB() : 0, light);
        matrixStack.method_22909();
    }

    @Unique
    private static void drawHeart(Matrix4f model, class_4588 vertexConsumer, float x, float y, float z, HeartType type) {
        float minU = (float)type.u / 256.0f;
        float maxU = minU + 0.03515625f;
        float minV = (float)type.v / 256.0f;
        float maxV = minV + 0.03515625f;
        float heartSize = 9.0f;
        NewEntityRendererMixin.drawVertex(model, vertexConsumer, x, y - heartSize, z, minU, maxV);
        NewEntityRendererMixin.drawVertex(model, vertexConsumer, x - heartSize, y - heartSize, z, maxU, maxV);
        NewEntityRendererMixin.drawVertex(model, vertexConsumer, x - heartSize, y, z, maxU, minV);
        NewEntityRendererMixin.drawVertex(model, vertexConsumer, x, y, z, minU, minV);
    }

    @Unique
    private static void drawVertex(Matrix4f model, class_4588 vertices, float x, float y, float z, float u, float v) {
        vertices.method_22918(model, x, y, z).method_22913(u, v).method_1344();
    }
}

